/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.extension;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.fabric.command.AbstractExtensionsCommand;
import org.fabric3.fabric.command.AttachWireCommand;
import org.fabric3.fabric.command.ConnectionCommand;
import org.fabric3.fabric.command.DetachWireCommand;
import org.fabric3.fabric.command.ProvisionExtensionsCommand;
import org.fabric3.fabric.command.UnProvisionExtensionsCommand;
import org.fabric3.fabric.command.WireCommand;
import org.fabric3.fabric.generator.GenerationType;
import org.fabric3.fabric.generator.extension.ExtensionGenerator;
import org.fabric3.host.Names;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.command.CompensatableCommand;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalInterceptorDefinition;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionGeneratorImpl
implements ExtensionGenerator {
    private MetaDataStore store;
    private HostInfo info;

    public ExtensionGeneratorImpl(@Reference MetaDataStore store, @Reference HostInfo info) {
        this.store = store;
        this.info = info;
    }

    @Override
    public Map<String, CompensatableCommand> generate(Map<String, List<Contribution>> contributions, List<LogicalComponent<?>> components, Map<String, List<CompensatableCommand>> deploymentCommands, GenerationType type) throws GenerationException {
        if (RuntimeMode.CONTROLLER != this.info.getRuntimeMode()) {
            return null;
        }
        HashMap<String, CompensatableCommand> commands = new HashMap<String, CompensatableCommand>();
        this.evaluateContributions(contributions, commands, type);
        this.evaluateComponents(components, commands, type);
        this.evaluatePolicies(commands, contributions, deploymentCommands, type);
        if (commands.isEmpty()) {
            return null;
        }
        return commands;
    }

    private void evaluateContributions(Map<String, List<Contribution>> contributions, Map<String, CompensatableCommand> commands, GenerationType type) throws GenerationException {
        for (Map.Entry<String, List<Contribution>> entry : contributions.entrySet()) {
            String zone = entry.getKey();
            if ("LocalZone".equals(zone)) continue;
            AbstractExtensionsCommand command = type == GenerationType.UNDEPLOY ? new UnProvisionExtensionsCommand() : new ProvisionExtensionsCommand();
            List<Contribution> zoneContributions = entry.getValue();
            HashSet extensions = new HashSet();
            for (Contribution contribution : zoneContributions) {
                Set required = this.store.resolveCapabilities(contribution);
                extensions.addAll(required);
            }
            for (Contribution extension : extensions) {
                URI uri = extension.getUri();
                command.addExtensionUri(uri);
            }
            if (command.getExtensionUris().isEmpty()) continue;
            commands.put(zone, command);
        }
    }

    private void evaluateComponents(List<LogicalComponent<?>> components, Map<String, CompensatableCommand> commands, GenerationType type) throws GenerationException {
        for (LogicalComponent<?> component : components) {
            String zone = component.getZone();
            if ("LocalZone".equals(zone)) continue;
            AbstractExtensionsCommand command = this.getExtensionsCommand(commands, zone, type);
            this.evaluateComponent(component, command, type);
            if (command.getExtensionUris().isEmpty()) continue;
            commands.put(zone, command);
        }
    }

    private void evaluateComponent(LogicalComponent<?> component, AbstractExtensionsCommand command, GenerationType type) throws GenerationException {
        Implementation impl = component.getDefinition().getImplementation();
        ComponentType componentType = impl.getComponentType();
        HashSet extensions = new HashSet();
        if (this.isGenerate(component.getState(), type)) {
            for (String capability : componentType.getRequiredCapabilities()) {
                extensions.addAll(this.store.resolveCapability(capability));
            }
            for (String capability : impl.getRequiredCapabilities()) {
                extensions.addAll(this.store.resolveCapability(capability));
            }
        }
        for (LogicalService service : component.getServices()) {
            for (LogicalBinding binding : service.getBindings()) {
                if (!this.isGenerate(binding.getState(), type)) continue;
                for (String capability : binding.getDefinition().getRequiredCapabilities()) {
                    extensions.addAll(this.store.resolveCapability(capability));
                }
            }
        }
        for (LogicalReference reference : component.getReferences()) {
            for (LogicalBinding binding : reference.getBindings()) {
                if (!this.isGenerate(binding.getState(), type)) continue;
                for (String capability : binding.getDefinition().getRequiredCapabilities()) {
                    extensions.addAll(this.store.resolveCapability(capability));
                }
            }
        }
        for (Contribution extension : extensions) {
            URI uri = extension.getUri();
            if (command.getExtensionUris().contains(uri) || Names.HOST_CONTRIBUTION.equals(uri) || Names.BOOT_CONTRIBUTION.equals(uri)) continue;
            command.addExtensionUri(uri);
        }
    }

    private boolean isGenerate(LogicalState state, GenerationType type) {
        if (GenerationType.FULL == type && LogicalState.MARKED != state) {
            return true;
        }
        if (GenerationType.INCREMENTAL == type && LogicalState.NEW == state) {
            return true;
        }
        return GenerationType.UNDEPLOY == type && LogicalState.MARKED == state;
    }

    private void evaluatePolicies(Map<String, CompensatableCommand> commands, Map<String, List<Contribution>> contributions, Map<String, List<CompensatableCommand>> deploymentCommands, GenerationType type) throws GenerationException {
        for (Map.Entry<String, List<CompensatableCommand>> entry : deploymentCommands.entrySet()) {
            String zone = entry.getKey();
            if (zone == null) continue;
            for (CompensatableCommand generatedCommand : entry.getValue()) {
                if (!(generatedCommand instanceof ConnectionCommand)) continue;
                ConnectionCommand connectionCommand = (ConnectionCommand)generatedCommand;
                if (GenerationType.UNDEPLOY == type) {
                    for (DetachWireCommand detachWireCommand : connectionCommand.getDetachCommands()) {
                        this.evaluateWireCommand(detachWireCommand, commands, contributions, zone, type);
                    }
                    continue;
                }
                for (AttachWireCommand attachWireCommand : connectionCommand.getAttachCommands()) {
                    this.evaluateWireCommand(attachWireCommand, commands, contributions, zone, type);
                }
            }
        }
    }

    private void evaluateWireCommand(WireCommand wireCommand, Map<String, CompensatableCommand> commands, Map<String, List<Contribution>> contributions, String zone, GenerationType type) throws GenerationException {
        for (PhysicalOperationDefinition operation : wireCommand.getPhysicalWireDefinition().getOperations()) {
            for (PhysicalInterceptorDefinition interceptor : operation.getInterceptors()) {
                URI contributionUri = interceptor.getPolicyClassLoaderId();
                Contribution contribution = this.store.find(contributionUri);
                if (this.findContribution(contribution, contributions)) continue;
                AbstractExtensionsCommand command = this.getExtensionsCommand(commands, zone, type);
                if (!(command.getExtensionUris().contains(contributionUri) || Names.HOST_CONTRIBUTION.equals(contributionUri) || Names.BOOT_CONTRIBUTION.equals(contributionUri))) {
                    command.addExtensionUri(contributionUri);
                }
                commands.put(zone, command);
                this.addDependencies(contribution, command);
            }
        }
    }

    private boolean findContribution(Contribution contribution, Map<String, List<Contribution>> contributions) {
        for (List<Contribution> list : contributions.values()) {
            if (!list.contains(contribution)) continue;
            return true;
        }
        return false;
    }

    private void addDependencies(Contribution contribution, AbstractExtensionsCommand command) throws GenerationException {
        List contributionWires = contribution.getWires();
        for (ContributionWire wire : contributionWires) {
            URI importedUri = wire.getExportContributionUri();
            Contribution imported = this.store.find(importedUri);
            this.addDependencies(imported, command);
            if (command.getExtensionUris().contains(importedUri) || Names.HOST_CONTRIBUTION.equals(importedUri) || Names.BOOT_CONTRIBUTION.equals(importedUri)) continue;
            command.addExtensionUri(importedUri);
        }
        Set capabilities = this.store.resolveCapabilities(contribution);
        for (Contribution capability : capabilities) {
            URI uri = capability.getUri();
            if (command.getExtensionUris().contains(uri)) continue;
            command.addExtensionUri(uri);
        }
    }

    private AbstractExtensionsCommand getExtensionsCommand(Map<String, CompensatableCommand> commands, String zone, GenerationType type) {
        AbstractExtensionsCommand command = (AbstractExtensionsCommand)commands.get(zone);
        if (command == null) {
            command = GenerationType.UNDEPLOY == type ? new UnProvisionExtensionsCommand() : new ProvisionExtensionsCommand();
        }
        return command;
    }
}

