/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.fabric3.fabric.generator.GeneratorNotFoundException;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.ResourceDefinition;
import org.fabric3.model.type.component.ResourceReferenceDefinition;
import org.fabric3.spi.generator.BindingGenerator;
import org.fabric3.spi.generator.ComponentGenerator;
import org.fabric3.spi.generator.ConnectionBindingGenerator;
import org.fabric3.spi.generator.InterceptorGenerator;
import org.fabric3.spi.generator.ResourceGenerator;
import org.fabric3.spi.generator.ResourceReferenceGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorRegistryImpl
implements GeneratorRegistry {
    private Map<Class<?>, ComponentGenerator<?>> componentGenerators = new ConcurrentHashMap();
    private Map<Class<?>, BindingGenerator<?>> bindingGenerators = new ConcurrentHashMap();
    private Map<Class<?>, ConnectionBindingGenerator<?>> connectionBindingGenerators = new ConcurrentHashMap();
    private Map<QName, InterceptorGenerator> interceptorGenerators = new ConcurrentHashMap<QName, InterceptorGenerator>();
    private Map<Class<?>, ResourceReferenceGenerator<?>> resourceReferenceGenerators = new ConcurrentHashMap();
    private Map<Class<?>, ResourceGenerator<?>> resourceGenerators = new ConcurrentHashMap();

    @Reference(required=false)
    public void setComponentGenerators(Map<Class<?>, ComponentGenerator<?>> componentGenerators) {
        this.componentGenerators = componentGenerators;
    }

    @Reference(required=false)
    public void setBindingGenerators(Map<Class<?>, BindingGenerator<?>> bindingGenerators) {
        this.bindingGenerators = bindingGenerators;
    }

    @Reference(required=false)
    public void setConnectionBindingGenerators(Map<Class<?>, ConnectionBindingGenerator<?>> bindingGenerators) {
        this.connectionBindingGenerators = bindingGenerators;
    }

    @Reference(required=false)
    public void setResourceReferenceGenerators(Map<Class<?>, ResourceReferenceGenerator<?>> resourceReferenceGenerators) {
        this.resourceReferenceGenerators = resourceReferenceGenerators;
    }

    @Reference(required=false)
    public void setInterceptorGenerators(Map<QName, InterceptorGenerator> interceptorGenerators) {
        this.interceptorGenerators = interceptorGenerators;
    }

    @Reference(required=false)
    public void setResourceGenerators(Map<Class<?>, ResourceGenerator<?>> resourceGenerators) {
        this.resourceGenerators = resourceGenerators;
    }

    public <T extends Implementation<?>> void register(Class<T> clazz, ComponentGenerator<LogicalComponent<T>> generator) {
        this.componentGenerators.put(clazz, generator);
    }

    public <T extends ResourceReferenceDefinition> void register(Class<T> clazz, ResourceReferenceGenerator<T> generator) {
        this.resourceReferenceGenerators.put(clazz, generator);
    }

    public <T extends BindingDefinition> void register(Class<T> clazz, BindingGenerator<T> generator) {
        this.bindingGenerators.put(clazz, generator);
    }

    @Override
    public <T extends Implementation<?>> ComponentGenerator<LogicalComponent<T>> getComponentGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        ComponentGenerator<?> generator = this.componentGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }

    @Override
    public <T extends BindingDefinition> BindingGenerator<T> getBindingGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        BindingGenerator<?> generator = this.bindingGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }

    public <T extends BindingDefinition> ConnectionBindingGenerator<T> getConnectionBindingGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        ConnectionBindingGenerator<?> generator = this.connectionBindingGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }

    @Override
    public <T extends ResourceReferenceDefinition> ResourceReferenceGenerator<T> getResourceReferenceGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        ResourceReferenceGenerator<?> generator = this.resourceReferenceGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }

    @Override
    public InterceptorGenerator getInterceptorDefinitionGenerator(QName extensionName) throws GeneratorNotFoundException {
        InterceptorGenerator generator = this.interceptorGenerators.get(extensionName);
        if (generator == null) {
            throw new GeneratorNotFoundException(extensionName);
        }
        return generator;
    }

    @Override
    public <T extends ResourceDefinition> ResourceGenerator<T> getResourceGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        ResourceGenerator<?> generator = this.resourceGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }
}

