/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.wire;

import java.util.List;
import org.fabric3.fabric.command.AttachWireCommand;
import org.fabric3.fabric.command.ConnectionCommand;
import org.fabric3.fabric.command.DetachWireCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.wire.WireGenerator;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundReferenceCommandGenerator
implements CommandGenerator {
    private final WireGenerator wireGenerator;
    private final int order;

    public BoundReferenceCommandGenerator(@Reference WireGenerator wireGenerator, @Property(name="order") int order) {
        this.wireGenerator = wireGenerator;
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public ConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent) {
            return null;
        }
        ConnectionCommand command = new ConnectionCommand();
        for (LogicalReference reference : component.getReferences()) {
            if (!reference.getWires().isEmpty()) continue;
            boolean reinjection = this.isReinjection(reference, incremental);
            for (LogicalBinding logicalBinding : reference.getBindings()) {
                this.generateCommand(component, logicalBinding, command, incremental, reinjection, false);
            }
            if (reference.getServiceContract().getCallbackContract() == null) continue;
            List callbackBindings = reference.getCallbackBindings();
            boolean bindings = reference.isConcreteBound();
            if (!bindings) continue;
            if (callbackBindings.size() != 1) {
                String uri = reference.getUri().toString();
                throw new UnsupportedOperationException("The runtime requires exactly one callback binding to be specified on reference: " + uri);
            }
            LogicalBinding callbackBinding = (LogicalBinding)callbackBindings.get(0);
            this.generateCommand(component, callbackBinding, command, incremental, reinjection, true);
        }
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return null;
        }
        return command;
    }

    private void generateCommand(LogicalComponent<?> component, LogicalBinding<?> logicalBinding, ConnectionCommand command, boolean incremental, boolean reinjection, boolean callback) throws GenerationException {
        if (LogicalState.MARKED == component.getState() || LogicalState.MARKED == logicalBinding.getState()) {
            PhysicalWireDefinition wireDefinition = callback ? this.wireGenerator.generateBoundReferenceCallback(logicalBinding) : this.wireGenerator.generateBoundReference(logicalBinding);
            DetachWireCommand wireCommand = new DetachWireCommand();
            wireCommand.setPhysicalWireDefinition(wireDefinition);
            command.add(wireCommand);
        } else if (LogicalState.NEW == logicalBinding.getState() || !incremental || reinjection) {
            PhysicalWireDefinition wireDefinition = callback ? this.wireGenerator.generateBoundReferenceCallback(logicalBinding) : this.wireGenerator.generateBoundReference(logicalBinding);
            AttachWireCommand wireCommand = new AttachWireCommand();
            wireCommand.setPhysicalWireDefinition(wireDefinition);
            command.add(wireCommand);
        }
    }

    private boolean isReinjection(LogicalReference logicalReference, boolean incremental) {
        Multiplicity multiplicity = logicalReference.getDefinition().getMultiplicity();
        if (incremental && multiplicity == Multiplicity.ZERO_N || multiplicity == Multiplicity.ONE_N) {
            for (LogicalBinding binding : logicalReference.getBindings()) {
                if (binding.getState() != LogicalState.NEW && binding.getState() != LogicalState.MARKED) continue;
                return true;
            }
        }
        return false;
    }
}

