/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.wire;

import java.net.URI;
import java.util.List;
import org.fabric3.fabric.command.AttachWireCommand;
import org.fabric3.fabric.command.ConnectionCommand;
import org.fabric3.fabric.command.DetachWireCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.wire.WireGenerator;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundServiceCommandGenerator
implements CommandGenerator {
    private final WireGenerator wireGenerator;
    private final int order;

    public BoundServiceCommandGenerator(@Reference WireGenerator wireGenerator, @Property(name="order") int order) {
        this.wireGenerator = wireGenerator;
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public ConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent) {
            return null;
        }
        boolean bindingChange = false;
        block0: for (LogicalService service : component.getServices()) {
            for (LogicalBinding binding : service.getBindings()) {
                if (binding.getState() != LogicalState.NEW && binding.getState() != LogicalState.MARKED) continue;
                bindingChange = true;
                continue block0;
            }
        }
        if (LogicalState.PROVISIONED == component.getState() && incremental && !bindingChange) {
            return null;
        }
        ConnectionCommand command = new ConnectionCommand();
        this.generatePhysicalWires(component, command, incremental);
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return null;
        }
        return command;
    }

    private void generatePhysicalWires(LogicalComponent<?> component, ConnectionCommand command, boolean incremental) throws GenerationException {
        for (LogicalService service : component.getServices()) {
            if (service.getBindings().isEmpty()) continue;
            ServiceContract callbackContract = service.getServiceContract().getCallbackContract();
            LogicalBinding callbackBinding = null;
            URI callbackUri = null;
            if (callbackContract != null) {
                List callbackBindings = service.getCallbackBindings();
                if (callbackBindings.size() != 1) {
                    String uri = service.getUri().toString();
                    throw new UnsupportedOperationException("The runtime requires exactly one callback binding to be specified on service: " + uri);
                }
                callbackBinding = (LogicalBinding)callbackBindings.get(0);
                callbackUri = callbackBinding.getDefinition().getTargetUri();
            }
            for (LogicalBinding binding : service.getBindings()) {
                if (binding.getState() != LogicalState.NEW && binding.getState() != LogicalState.MARKED && incremental) continue;
                PhysicalWireDefinition pwd = this.wireGenerator.generateBoundService(binding, callbackUri);
                if (LogicalState.MARKED == binding.getState()) {
                    DetachWireCommand detachWireCommand = new DetachWireCommand();
                    detachWireCommand.setPhysicalWireDefinition(pwd);
                    command.add(detachWireCommand);
                    continue;
                }
                AttachWireCommand attachWireCommand = new AttachWireCommand();
                attachWireCommand.setPhysicalWireDefinition(pwd);
                command.add(attachWireCommand);
            }
            if (callbackBinding == null || callbackBinding.getState() != LogicalState.NEW && callbackBinding.getState() != LogicalState.MARKED && incremental) continue;
            PhysicalWireDefinition callbackPwd = this.wireGenerator.generateBoundServiceCallback(callbackBinding);
            if (LogicalState.MARKED == callbackBinding.getState()) {
                DetachWireCommand detachWireCommand = new DetachWireCommand();
                detachWireCommand.setPhysicalWireDefinition(callbackPwd);
                command.add(detachWireCommand);
                continue;
            }
            AttachWireCommand attachWireCommand = new AttachWireCommand();
            attachWireCommand.setPhysicalWireDefinition(callbackPwd);
            command.add(attachWireCommand);
        }
    }
}

