/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.wire;

import org.fabric3.fabric.command.AttachWireCommand;
import org.fabric3.fabric.command.ConnectionCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.wire.WireGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceReferenceCommandGenerator
implements CommandGenerator {
    private final WireGenerator wireGenerator;
    private final int order;

    public ResourceReferenceCommandGenerator(@Reference WireGenerator wireGenerator, @Property(name="order") int order) {
        this.wireGenerator = wireGenerator;
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public ConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent || component.getResourceReferences().isEmpty() || component.getState() != LogicalState.NEW && incremental) {
            return null;
        }
        ConnectionCommand command = new ConnectionCommand();
        for (LogicalResourceReference resourceReference : component.getResourceReferences()) {
            AttachWireCommand attachWireCommand = new AttachWireCommand();
            PhysicalWireDefinition pwd = this.wireGenerator.generateResource(resourceReference);
            attachWireCommand.setPhysicalWireDefinition(pwd);
            command.add(attachWireCommand);
        }
        return command;
    }
}

