/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.wire;

import org.fabric3.fabric.command.AttachWireCommand;
import org.fabric3.fabric.command.ConnectionCommand;
import org.fabric3.fabric.command.DetachWireCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.wire.WireGenerator;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireCommandGenerator
implements CommandGenerator {
    private WireGenerator wireGenerator;
    private int order;

    public WireCommandGenerator(@Reference WireGenerator wireGenerator, @Property(name="order") int order) {
        this.wireGenerator = wireGenerator;
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public ConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent) {
            return null;
        }
        ConnectionCommand command = new ConnectionCommand();
        for (LogicalReference logicalReference : component.getReferences()) {
            this.generateWires(logicalReference, command, incremental);
        }
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return null;
        }
        return command;
    }

    private void generateWires(LogicalReference reference, ConnectionCommand command, boolean incremental) throws GenerationException {
        boolean reinjection = this.isReinjection(reference, incremental);
        for (LogicalWire wire : reference.getWires()) {
            AttachWireCommand attachCommand;
            DetachWireCommand detachCommand;
            PhysicalWireDefinition pwd;
            LogicalService service = wire.getTarget();
            LogicalComponent targetComponent = service.getLeafComponent();
            if (!reinjection && wire.getState() == LogicalState.PROVISIONED && targetComponent.getState() != LogicalState.MARKED && incremental) continue;
            boolean attach = true;
            if (targetComponent.getState() == LogicalState.MARKED || wire.getState() == LogicalState.MARKED) {
                attach = false;
                pwd = this.wireGenerator.generateWire(wire);
                detachCommand = new DetachWireCommand();
                detachCommand.setPhysicalWireDefinition(pwd);
                command.add(detachCommand);
            } else if (reinjection && targetComponent.getState() == LogicalState.NEW || !incremental || wire.getState() == LogicalState.NEW || targetComponent.getState() == LogicalState.NEW) {
                pwd = this.wireGenerator.generateWire(wire);
                attachCommand = new AttachWireCommand();
                attachCommand.setPhysicalWireDefinition(pwd);
                command.add(attachCommand);
            }
            if (reference.getServiceContract().getCallbackContract() == null) continue;
            pwd = this.wireGenerator.generateWireCallback(wire);
            if (attach) {
                attachCommand = new AttachWireCommand();
                attachCommand.setPhysicalWireDefinition(pwd);
                command.add(attachCommand);
                continue;
            }
            detachCommand = new DetachWireCommand();
            detachCommand.setPhysicalWireDefinition(pwd);
            command.add(detachCommand);
        }
    }

    private boolean isReinjection(LogicalReference logicalReference, boolean incremental) {
        Multiplicity multiplicity = logicalReference.getDefinition().getMultiplicity();
        if (incremental && multiplicity == Multiplicity.ZERO_N || multiplicity == Multiplicity.ONE_N) {
            for (LogicalWire wire : logicalReference.getWires()) {
                LogicalComponent targetComponent = wire.getTarget().getLeafComponent();
                if (wire.getState() != LogicalState.NEW && wire.getState() != LogicalState.MARKED && targetComponent.getState() != LogicalState.NEW && targetComponent.getState() != LogicalState.MARKED) continue;
                return true;
            }
        }
        return false;
    }
}

