/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.component;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.component.InvalidProperty;
import org.fabric3.fabric.instantiator.component.InvalidPropertyFile;
import org.fabric3.fabric.instantiator.component.PropertySourceNotFound;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Property;
import org.fabric3.model.type.component.PropertyValue;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentInstantiator {
    private static final DocumentBuilderFactory DOCUMENT_FACTORY = DocumentBuilderFactory.newInstance();
    private static final XPathFactory XPATH_FACTORY;

    protected void initializeProperties(LogicalComponent<?> component, ComponentDefinition<?> definition, InstantiationContext context) {
        Map propertyValues = definition.getPropertyValues();
        ComponentType componentType = definition.getComponentType();
        for (Property property : componentType.getProperties().values()) {
            Document value;
            String name = property.getName();
            PropertyValue propertyValue = (PropertyValue)propertyValues.get(name);
            if (propertyValue == null) {
                value = property.getDefaultValue();
            } else if (propertyValue.getFile() != null) {
                value = this.loadValueFromFile(property.getName(), propertyValue.getFile(), component, context);
            } else if (propertyValue.getSource() != null) {
                try {
                    value = this.deriveValueFromXPath(propertyValue.getSource(), (LogicalComponent)component.getParent(), propertyValue.getNamespaceContext());
                }
                catch (XPathExpressionException e) {
                    URI uri = component.getUri();
                    URI contributionUri = component.getDefinition().getContributionUri();
                    InvalidProperty error = new InvalidProperty(name, e, uri, contributionUri);
                    context.addError(error);
                    return;
                }
            } else {
                value = propertyValue.getValue();
            }
            if (property.isRequired() && value == null) {
                URI uri = component.getUri();
                URI contributionUri = component.getDefinition().getContributionUri();
                PropertySourceNotFound error = new PropertySourceNotFound(name, uri, contributionUri);
                context.addError(error);
                continue;
            }
            if (!property.isRequired() && value == null) continue;
            boolean many = property.isMany();
            LogicalProperty logicalProperty = new LogicalProperty(name, value, many, component);
            component.setProperties(logicalProperty);
        }
    }

    Document deriveValueFromXPath(String source, final LogicalComponent<?> parent, NamespaceContext nsContext) throws XPathExpressionException {
        DocumentBuilder builder;
        XPathVariableResolver variableResolver = new XPathVariableResolver(){

            public Object resolveVariable(QName qName) {
                String name = qName.getLocalPart();
                LogicalProperty property = parent.getProperties(name);
                if (property == null) {
                    return null;
                }
                Document value = property.getValue();
                if (value == null || value.getDocumentElement().getChildNodes().getLength() == 0) {
                    return null;
                }
                return value.getDocumentElement().getFirstChild();
            }
        };
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setXPathVariableResolver(variableResolver);
        xpath.setNamespaceContext(nsContext);
        try {
            builder = DOCUMENT_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        Document document = builder.newDocument();
        Element root = document.createElement("values");
        document.appendChild(root);
        NodeList result = (NodeList)xpath.evaluate(source, document, XPathConstants.NODESET);
        if (result.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < result.getLength(); ++i) {
            Element value;
            Node node = result.item(i);
            if (!"value".equals(node.getNodeName())) {
                value = document.createElement("value");
                root.appendChild(value);
            } else {
                value = root;
            }
            Node cloned = node.cloneNode(true);
            document.adoptNode(cloned);
            short type = cloned.getNodeType();
            if (1 == type || 3 == type) {
                value.appendChild(cloned);
                continue;
            }
            if (2 == type) {
                Element element = document.createElement(cloned.getNodeName());
                element.setTextContent(cloned.getNodeValue());
                value.appendChild(element);
                continue;
            }
            throw new XPathExpressionException("Unsupported node type: " + type);
        }
        return document;
    }

    public Document loadValueFromFile(String name, URI fileUri, LogicalComponent<?> parent, InstantiationContext context) {
        try {
            DocumentBuilder builder = DOCUMENT_FACTORY.newDocumentBuilder();
            Document document = builder.parse(fileUri.toString());
            Element root = document.getDocumentElement();
            if (!"values".equals(root.getNodeName())) {
                if ("value".equals(root.getNodeName())) {
                    Element newRoot = document.createElement("values");
                    document.removeChild(root);
                    document.appendChild(newRoot);
                    newRoot.appendChild(root);
                } else {
                    Element newRoot = document.createElement("values");
                    document.removeChild(root);
                    document.appendChild(newRoot);
                    Element value = document.createElement("value");
                    newRoot.appendChild(value);
                    value.appendChild(root);
                }
            }
            return document;
        }
        catch (IOException e) {
            URI uri = parent.getUri();
            URI contributionUri = parent.getDefinition().getContributionUri();
            InvalidPropertyFile error = new InvalidPropertyFile(name, e, fileUri, uri, contributionUri);
            context.addError(error);
            return null;
        }
        catch (SAXException e) {
            URI uri = parent.getUri();
            URI contributionUri = parent.getDefinition().getContributionUri();
            InvalidPropertyFile error = new InvalidPropertyFile(name, e, fileUri, uri, contributionUri);
            context.addError(error);
            return null;
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        DOCUMENT_FACTORY.setNamespaceAware(true);
        XPATH_FACTORY = XPathFactory.newInstance();
    }
}

