/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.promotion;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.fabric3.fabric.instantiator.AmbiguousReference;
import org.fabric3.fabric.instantiator.AmbiguousService;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.NoServiceOnComponent;
import org.fabric3.fabric.instantiator.PromotedComponentNotFound;
import org.fabric3.fabric.instantiator.PromotionResolutionService;
import org.fabric3.fabric.instantiator.ReferenceNotFound;
import org.fabric3.fabric.instantiator.ServiceNotFound;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.util.UriHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotionResolutionServiceImpl
implements PromotionResolutionService {
    @Override
    public void resolve(LogicalComponent<?> component, InstantiationContext context) {
        this.resolveReferences(component, context);
        this.resolveServices(component, context);
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent compositeComponent = (LogicalCompositeComponent)component;
            for (LogicalComponent child : compositeComponent.getComponents()) {
                this.resolve(child, context);
            }
        }
    }

    private void resolveReferences(LogicalComponent<?> component, InstantiationContext context) {
        for (LogicalReference reference : component.getReferences()) {
            boolean refMultiplicity;
            Multiplicity multiplicityValue = reference.getDefinition().getMultiplicity();
            boolean bl = refMultiplicity = multiplicityValue.equals((Object)Multiplicity.ZERO_N) || multiplicityValue.equals((Object)Multiplicity.ONE_N);
            if (!refMultiplicity && reference.isResolved()) continue;
            reference.setResolved(false);
            this.resolve(reference, context);
        }
    }

    private void resolveServices(LogicalComponent<?> component, InstantiationContext context) {
        for (LogicalService logicalService : component.getServices()) {
            this.resolve(logicalService, context);
        }
    }

    void resolve(LogicalService logicalService, InstantiationContext context) {
        URI promotedUri = logicalService.getPromotedUri();
        if (promotedUri == null) {
            return;
        }
        URI promotedComponentUri = UriHelper.getDefragmentedName((URI)promotedUri);
        String promotedServiceName = promotedUri.getFragment();
        LogicalCompositeComponent composite = (LogicalCompositeComponent)logicalService.getParent();
        LogicalComponent promotedComponent = composite.getComponent(promotedComponentUri);
        if (promotedComponent == null) {
            LogicalComponent parent = (LogicalComponent)logicalService.getParent();
            URI componentUri = parent.getUri();
            URI serviceUri = logicalService.getUri();
            URI contributionUri = parent.getDefinition().getContributionUri();
            PromotedComponentNotFound error = new PromotedComponentNotFound(serviceUri, promotedComponentUri, componentUri, contributionUri);
            context.addError(error);
            return;
        }
        if (promotedServiceName == null) {
            Collection componentServices = promotedComponent.getServices();
            if (componentServices.size() == 0) {
                this.raiseNoServiceError(logicalService, promotedComponentUri, context);
            } else if (componentServices.size() == 2) {
                this.raiseAmbiguousServiceError(logicalService, promotedComponentUri, context);
            } else if (componentServices.size() > 2) {
                this.raiseAmbiguousServiceError(logicalService, promotedComponentUri, context);
            } else {
                logicalService.setPromotedUri(((LogicalService)componentServices.iterator().next()).getUri());
            }
        } else if (promotedComponent.getService(promotedServiceName) == null) {
            this.raiseServiceNotFoundError(logicalService, promotedComponentUri, promotedServiceName, context);
        }
    }

    void resolve(LogicalReference reference, InstantiationContext context) {
        List promotedUris = reference.getPromotedUris();
        for (int i = 0; i < promotedUris.size(); ++i) {
            URI promotedUri = (URI)promotedUris.get(i);
            URI promotedComponentUri = UriHelper.getDefragmentedName((URI)promotedUri);
            String promotedReferenceName = promotedUri.getFragment();
            LogicalCompositeComponent parent = (LogicalCompositeComponent)reference.getParent();
            LogicalComponent promotedComponent = parent.getComponent(promotedComponentUri);
            if (promotedComponent == null) {
                this.raiseComponentNotFoundError(reference, promotedComponentUri, parent, context);
                return;
            }
            if (promotedReferenceName == null) {
                Collection componentReferences = promotedComponent.getReferences();
                if (componentReferences.size() == 0) {
                    this.raiseReferenceNotFoundError(promotedReferenceName, promotedComponentUri, parent, context);
                    return;
                }
                if (componentReferences.size() > 1) {
                    URI referenceUri = reference.getUri();
                    URI contributionUri = parent.getDefinition().getContributionUri();
                    AmbiguousReference error = new AmbiguousReference(referenceUri, parent.getUri(), promotedComponentUri, contributionUri);
                    context.addError(error);
                    return;
                }
                LogicalReference promotedReference = (LogicalReference)componentReferences.iterator().next();
                reference.setPromotedUri(i, promotedReference.getUri());
                promotedReference.setResolved(true);
                continue;
            }
            LogicalReference promotedReference = promotedComponent.getReference(promotedReferenceName);
            if (promotedReference == null) {
                this.raiseReferenceNotFoundError(promotedReferenceName, promotedComponentUri, parent, context);
                return;
            }
            promotedReference.setResolved(true);
        }
    }

    private void raiseReferenceNotFoundError(String referenceName, URI uri, LogicalCompositeComponent parent, InstantiationContext context) {
        String msg = "Reference " + referenceName + " not found on component " + uri;
        URI componentUri = parent.getUri();
        URI contributionUri = parent.getDefinition().getContributionUri();
        ReferenceNotFound error = new ReferenceNotFound(msg, referenceName, componentUri, contributionUri);
        context.addError(error);
    }

    private void raiseComponentNotFoundError(LogicalReference reference, URI uri, LogicalCompositeComponent parent, InstantiationContext context) {
        URI componentUri = parent.getUri();
        URI referenceUri = reference.getUri();
        URI contributionUri = parent.getDefinition().getContributionUri();
        PromotedComponentNotFound error = new PromotedComponentNotFound(referenceUri, uri, componentUri, contributionUri);
        context.addError(error);
    }

    private void raiseServiceNotFoundError(LogicalService service, URI uri, String name, InstantiationContext context) {
        String message = "Service " + name + " promoted from " + service.getUri() + " not found on component " + uri;
        URI componentUri = ((LogicalComponent)service.getParent()).getUri();
        URI contributionUri = ((LogicalComponent)service.getParent()).getDefinition().getContributionUri();
        URI serviceUri = service.getUri();
        ServiceNotFound error = new ServiceNotFound(message, serviceUri, componentUri, contributionUri);
        context.addError(error);
    }

    private void raiseNoServiceError(LogicalService service, URI uri, InstantiationContext context) {
        LogicalComponent parent = (LogicalComponent)service.getParent();
        URI componentUri = parent.getUri();
        URI contributionUri = parent.getDefinition().getContributionUri();
        String msg = "No services available on component: " + uri;
        NoServiceOnComponent error = new NoServiceOnComponent(msg, componentUri, contributionUri);
        context.addError(error);
    }

    private void raiseAmbiguousServiceError(LogicalService service, URI uri, InstantiationContext context) {
        String msg = "The promoted service " + service.getUri() + " must explicitly specify the service it is promoting on component " + uri + " as the component has more than one service";
        LogicalComponent parent = (LogicalComponent)service.getParent();
        URI componentUri = parent.getUri();
        URI contributionUri = parent.getDefinition().getContributionUri();
        AmbiguousService error = new AmbiguousService(msg, componentUri, contributionUri);
        context.addError(error);
    }
}

