/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.wire;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.instantiator.AmbiguousService;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.NoServiceOnComponent;
import org.fabric3.fabric.instantiator.ServiceNotFound;
import org.fabric3.fabric.instantiator.WireInstantiator;
import org.fabric3.fabric.instantiator.wire.BindingNotFound;
import org.fabric3.fabric.instantiator.wire.IncompatibleContracts;
import org.fabric3.fabric.instantiator.wire.KeyNotFound;
import org.fabric3.fabric.instantiator.wire.TargetComponentNotFound;
import org.fabric3.fabric.instantiator.wire.WireSourceAmbiguousReference;
import org.fabric3.fabric.instantiator.wire.WireSourceNoReference;
import org.fabric3.fabric.instantiator.wire.WireSourceNotFound;
import org.fabric3.fabric.instantiator.wire.WireSourceReferenceNotFound;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ComponentReference;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.Target;
import org.fabric3.model.type.component.WireDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.type.binding.SCABinding;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireInstantiatorImpl
implements WireInstantiator {
    private ContractMatcher matcher;

    public WireInstantiatorImpl(@Reference ContractMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public void instantiateCompositeWires(Composite composite, LogicalCompositeComponent parent, InstantiationContext context) {
        for (WireDefinition definition : composite.getWires()) {
            Target serviceTarget;
            LogicalService service;
            URI contributionUri = composite.getContributionUri();
            Target referenceTarget = definition.getReferenceTarget();
            LogicalReference reference = this.resolveReference(referenceTarget, parent, contributionUri, context);
            if (reference == null || (service = this.resolveService(reference, serviceTarget = definition.getServiceTarget(), parent, context)) == null) continue;
            QName deployable = parent.getDeployable();
            LogicalWire wire = new LogicalWire((LogicalComponent)parent, reference, service, deployable);
            wire.setReplaces(definition.isReplace());
            String referenceBindingName = referenceTarget.getBinding();
            String serviceBindingName = serviceTarget.getBinding();
            this.resolveBindings(reference, referenceBindingName, service, wire, serviceBindingName, context);
            parent.addWire(reference, wire);
        }
    }

    @Override
    public void instantiateReferenceWires(LogicalComponent<?> component, InstantiationContext context) {
        for (LogicalReference logicalReference : component.getReferences()) {
            this.instantiateReferenceWires(logicalReference, context);
        }
    }

    private void instantiateReferenceWires(LogicalReference reference, InstantiationContext context) {
        SCABinding scaBinding;
        LogicalCompositeComponent parent = (LogicalCompositeComponent)((LogicalComponent)reference.getParent()).getParent();
        ComponentReference componentReference = reference.getComponentReference();
        if (componentReference == null) {
            return;
        }
        List serviceTargets = componentReference.getTargets();
        ArrayList<SCABinding> scaBindings = new ArrayList<SCABinding>();
        for (BindingDefinition binding : componentReference.getBindings()) {
            if (!(binding instanceof SCABinding)) continue;
            scaBinding = (SCABinding)binding;
            scaBindings.add(scaBinding);
        }
        if (scaBindings.isEmpty()) {
            for (BindingDefinition binding : reference.getDefinition().getBindings()) {
                if (!(binding instanceof SCABinding)) continue;
                scaBinding = (SCABinding)binding;
                scaBindings.add(scaBinding);
            }
        }
        if (serviceTargets.isEmpty() && scaBindings.isEmpty()) {
            return;
        }
        List existingWires = reference.getWires();
        for (LogicalWire wire : existingWires) {
            if (!wire.isReplaces()) continue;
            reference.setResolved(true);
            return;
        }
        ArrayList<LogicalWire> wires = new ArrayList<LogicalWire>();
        if (!scaBindings.isEmpty()) {
            for (SCABinding binding : scaBindings) {
                String bindingName;
                Target target = binding.getTarget();
                LogicalWire wire = this.createWire(target, reference, bindingName = binding.getName(), parent, context);
                if (wire == null) continue;
                wires.add(wire);
            }
        } else {
            for (Target target : serviceTargets) {
                LogicalWire wire = this.createWire(target, reference, null, parent, context);
                if (wire == null) continue;
                wires.add(wire);
            }
        }
        if (!wires.isEmpty()) {
            parent.addWires(reference, wires);
        }
        reference.setResolved(true);
    }

    private LogicalWire createWire(Target target, LogicalReference reference, String bindingName, LogicalCompositeComponent parent, InstantiationContext context) {
        LogicalService service = this.resolveService(reference, target, parent, context);
        if (service == null) {
            return null;
        }
        QName deployable = ((LogicalComponent)service.getParent()).getDeployable();
        LogicalWire wire = new LogicalWire((LogicalComponent)parent, reference, service, deployable, true);
        String serviceBindingName = target.getBinding();
        this.resolveBindings(reference, bindingName, service, wire, serviceBindingName, context);
        return wire;
    }

    private LogicalReference resolveReference(Target target, LogicalCompositeComponent parent, URI contributionUri, InstantiationContext context) {
        LogicalReference logicalReference;
        String base = parent.getUri().toString();
        URI componentUri = URI.create(base + "/" + target.getComponent());
        String referenceName = target.getBindable();
        LogicalComponent source = parent.getComponent(componentUri);
        if (source == null) {
            this.raiseWireSourceNotFound(componentUri, parent, contributionUri, context);
            return null;
        }
        if (referenceName == null) {
            if (source.getReferences().size() == 0) {
                this.raiseWireSourceNoReference(componentUri, parent, contributionUri, context);
                return null;
            }
            if (source.getReferences().size() != 1) {
                this.raiseWireSourceAmbiguousReference(componentUri, parent, contributionUri, context);
                return null;
            }
            logicalReference = (LogicalReference)source.getReferences().iterator().next();
        } else {
            logicalReference = source.getReference(referenceName);
            if (logicalReference == null) {
                this.raiseWireSourceNotFound(componentUri, referenceName, parent, contributionUri, context);
                return null;
            }
        }
        return logicalReference;
    }

    private LogicalService resolveService(LogicalReference reference, Target target, LogicalCompositeComponent parent, InstantiationContext context) {
        URI targetComponentUri = URI.create(parent.getUri().toString() + "/" + target.getComponent());
        LogicalComponent targetComponent = parent.getComponent(targetComponentUri);
        if (targetComponent == null) {
            URI referenceUri = reference.getUri();
            URI contributionUri = ((LogicalComponent)reference.getParent()).getDefinition().getContributionUri();
            URI parentUri = parent.getUri();
            TargetComponentNotFound error = new TargetComponentNotFound(referenceUri, targetComponentUri, parentUri, contributionUri);
            context.addError(error);
            return null;
        }
        String serviceName = target.getBindable();
        LogicalService targetService = null;
        if (serviceName != null) {
            targetService = targetComponent.getService(serviceName);
            if (targetService == null) {
                this.raiseServiceNotFound(reference, target, parent, context);
                return null;
            }
        } else {
            for (LogicalService service : targetComponent.getServices()) {
                if (targetService != null) {
                    this.raiseAmbiguousService(reference, target, parent, context);
                    return null;
                }
                targetService = service;
            }
            if (targetService == null) {
                this.raiseNoService(reference, target, parent, context);
                return null;
            }
        }
        this.validate(reference, targetService, context);
        return targetService;
    }

    private void resolveBindings(LogicalReference reference, String referenceBindingName, LogicalService service, LogicalWire wire, String serviceBindingName, InstantiationContext context) {
        LogicalBinding<?> referenceBinding;
        if (serviceBindingName == null) {
            return;
        }
        LogicalBinding<?> serviceBinding = this.getBinding(serviceBindingName, (Bindable)service);
        if (serviceBinding == null) {
            this.raiseServiceBindingNotFound(service, serviceBindingName, context);
        }
        if (referenceBindingName != null) {
            referenceBinding = this.getBinding(referenceBindingName, (Bindable)reference);
        } else if (serviceBinding != null) {
            referenceBinding = this.selectBinding((Bindable)reference, serviceBinding);
        } else {
            return;
        }
        wire.setSourceBinding(referenceBinding);
        wire.setTargetBinding(serviceBinding);
        if (serviceBinding != null && referenceBinding != null && !referenceBinding.getDefinition().getType().equals(serviceBinding.getDefinition().getType())) {
            this.raiseIncompatibleBindings(reference, service, referenceBindingName, context);
        }
    }

    private LogicalBinding<?> selectBinding(Bindable bindable, LogicalBinding binding) {
        for (LogicalBinding candidate : bindable.getBindings()) {
            if (!candidate.getDefinition().getType().equals(binding.getDefinition().getType())) continue;
            return candidate;
        }
        return null;
    }

    private LogicalBinding<?> getBinding(String name, Bindable bindable) {
        LogicalBinding selectedBinding = null;
        for (LogicalBinding binding : bindable.getBindings()) {
            if (!name.equals(binding.getDefinition().getName())) continue;
            selectedBinding = binding;
            break;
        }
        return selectedBinding;
    }

    private void validate(LogicalReference reference, LogicalService service, InstantiationContext context) {
        this.validateKeyedReference(reference, service, context);
        this.validateContracts(reference, service, context);
    }

    private void validateKeyedReference(LogicalReference reference, LogicalService service, InstantiationContext context) {
        if (!reference.getDefinition().isKeyed()) {
            return;
        }
        LogicalComponent parent = (LogicalComponent)service.getParent();
        if (parent.getDefinition().getKey() == null) {
            URI contributionUri = parent.getDefinition().getContributionUri();
            KeyNotFound error = new KeyNotFound(reference.getUri(), parent.getUri(), contributionUri);
            context.addError(error);
        }
    }

    private void validateContracts(LogicalReference reference, LogicalService service, InstantiationContext context) {
        ServiceContract serviceContract;
        ServiceContract referenceContract = reference.getServiceContract();
        MatchResult result = this.matcher.isAssignableFrom(referenceContract, serviceContract = service.getServiceContract(), true);
        if (!result.isAssignable()) {
            URI uri = ((LogicalComponent)reference.getParent()).getUri();
            URI referenceUri = reference.getUri();
            URI serviceUri = service.getUri();
            URI contributionUri = ((LogicalComponent)reference.getParent()).getDefinition().getContributionUri();
            String message = result.getError();
            IncompatibleContracts error = new IncompatibleContracts(referenceUri, serviceUri, uri, message, contributionUri);
            context.addError(error);
        }
    }

    private void raiseWireSourceNotFound(URI componentUri, String referenceName, LogicalCompositeComponent parent, URI contributionUri, InstantiationContext context) {
        URI uri = parent.getUri();
        WireSourceReferenceNotFound error = new WireSourceReferenceNotFound(componentUri, referenceName, uri, contributionUri);
        context.addError(error);
    }

    private void raiseWireSourceAmbiguousReference(URI componentUri, LogicalCompositeComponent parent, URI contributionUri, InstantiationContext context) {
        URI uri = parent.getUri();
        WireSourceAmbiguousReference error = new WireSourceAmbiguousReference(componentUri, uri, contributionUri);
        context.addError(error);
    }

    private void raiseWireSourceNoReference(URI componentUri, LogicalCompositeComponent parent, URI contributionUri, InstantiationContext context) {
        URI uri = parent.getUri();
        WireSourceNoReference error = new WireSourceNoReference(componentUri, uri, contributionUri);
        context.addError(error);
    }

    private void raiseWireSourceNotFound(URI componentUri, LogicalCompositeComponent parent, URI contributionUri, InstantiationContext context) {
        URI uri = parent.getUri();
        WireSourceNotFound error = new WireSourceNotFound(componentUri, uri, contributionUri);
        context.addError(error);
    }

    private void raiseNoService(LogicalReference reference, Target target, LogicalCompositeComponent parent, InstantiationContext context) {
        String componentName = target.getComponent();
        URI referenceUri = reference.getUri();
        String msg = "The reference " + referenceUri + " is wired to component " + componentName + " but the component has no services";
        URI contributionUri = ((LogicalComponent)reference.getParent()).getDefinition().getContributionUri();
        URI parentUri = parent.getUri();
        NoServiceOnComponent error = new NoServiceOnComponent(msg, parentUri, contributionUri);
        context.addError(error);
    }

    private void raiseAmbiguousService(LogicalReference reference, Target target, LogicalCompositeComponent parent, InstantiationContext context) {
        String componentName = target.getComponent();
        URI referenceUri = reference.getUri();
        String msg = "More than one service available on component: " + componentName + ". The wire from the reference" + referenceUri + " must explicitly specify a target service.";
        URI parentUri = parent.getUri();
        URI contributionUri = ((LogicalComponent)reference.getParent()).getDefinition().getContributionUri();
        AmbiguousService error = new AmbiguousService(msg, parentUri, contributionUri);
        context.addError(error);
    }

    private void raiseServiceNotFound(LogicalReference reference, Target target, LogicalCompositeComponent parent, InstantiationContext context) {
        URI referenceUri = reference.getUri();
        String componentName = target.getComponent();
        String serviceName = target.getBindable();
        String msg = "The service " + serviceName + " wired from the reference " + referenceUri + " is not found on component " + componentName;
        URI parentUri = parent.getUri();
        URI contributionUri = ((LogicalComponent)reference.getParent()).getDefinition().getContributionUri();
        ServiceNotFound error = new ServiceNotFound(msg, referenceUri, parentUri, contributionUri);
        context.addError(error);
    }

    private void raiseServiceBindingNotFound(LogicalService service, String name, InstantiationContext context) {
        LogicalCompositeComponent parent = (LogicalCompositeComponent)((LogicalComponent)service.getParent()).getParent();
        URI parentUri = parent.getUri();
        URI contributionUri = ((LogicalComponent)service.getParent()).getDefinition().getContributionUri();
        BindingNotFound error = new BindingNotFound("The binding " + name + "  for service " + service.getUri() + " was not found", parentUri, contributionUri);
        context.addError(error);
    }

    private void raiseIncompatibleBindings(LogicalReference reference, LogicalService service, String name, InstantiationContext context) {
        LogicalCompositeComponent parent = (LogicalCompositeComponent)((LogicalComponent)reference.getParent()).getParent();
        URI parentUri = parent.getUri();
        URI contributionUri = ((LogicalComponent)reference.getParent()).getDefinition().getContributionUri();
        BindingNotFound error = new BindingNotFound("The binding " + name + " for reference " + reference.getUri() + " and service " + service.getUri() + " are not compatible", parentUri, contributionUri);
        context.addError(error);
    }
}

