/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.policy;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.fabric3.model.type.definitions.AbstractPolicyDefinition;
import org.fabric3.model.type.definitions.BindingType;
import org.fabric3.model.type.definitions.ImplementationType;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.policy.PolicyActivationException;
import org.fabric3.spi.policy.PolicyRegistry;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolicyRegistry
implements PolicyRegistry {
    private MetaDataStore metaDataStore;
    private Map<Class<? extends AbstractPolicyDefinition>, Map<QName, ? extends AbstractPolicyDefinition>> cache = new ConcurrentHashMap<Class<? extends AbstractPolicyDefinition>, Map<QName, ? extends AbstractPolicyDefinition>>();

    public DefaultPolicyRegistry(@Reference MetaDataStore metaDataStore) {
        this.metaDataStore = metaDataStore;
        this.cache.put(Intent.class, new ConcurrentHashMap());
        this.cache.put(PolicySet.class, new ConcurrentHashMap());
        this.cache.put(BindingType.class, new ConcurrentHashMap());
        this.cache.put(ImplementationType.class, new ConcurrentHashMap());
    }

    public <D extends AbstractPolicyDefinition> Collection<D> getAllDefinitions(Class<D> definitionClass) {
        return this.getSubCache(definitionClass).values();
    }

    public List<PolicySet> getExternalAttachmentPolicies() {
        Map<QName, PolicySet> subCache = this.getSubCache(PolicySet.class);
        ArrayList<PolicySet> policySets = new ArrayList<PolicySet>();
        for (PolicySet policySet : subCache.values()) {
            if (policySet.getAttachTo() == null) continue;
            policySets.add(policySet);
        }
        return policySets;
    }

    public <D extends AbstractPolicyDefinition> D getDefinition(QName name, Class<D> definitionClass) {
        return (D)((AbstractPolicyDefinition)this.getSubCache(definitionClass).get(name));
    }

    public <D extends AbstractPolicyDefinition> Set<D> getDefinitions(Set<QName> names, Class<D> definitionClass) {
        Map<QName, D> subCache = this.getSubCache(definitionClass);
        if (subCache == null) {
            return Collections.emptySet();
        }
        return new HashSet<D>(subCache.values());
    }

    public void activateDefinitions(List<URI> contributionUris) throws PolicyActivationException {
        for (URI uri : contributionUris) {
            Contribution contribution = this.metaDataStore.find(uri);
            for (Resource resource : contribution.getResources()) {
                for (ResourceElement resourceElement : resource.getResourceElements()) {
                    Object value = resourceElement.getValue();
                    if (!(value instanceof AbstractPolicyDefinition)) continue;
                    this.activate((AbstractPolicyDefinition)value);
                }
            }
        }
    }

    public void activate(AbstractPolicyDefinition definition) throws PolicyActivationException {
        if (definition instanceof Intent) {
            QName name;
            Map<QName, Intent> subCache = this.getSubCache(Intent.class);
            if (subCache.containsKey(name = definition.getName())) {
                throw new PolicyActivationException("Duplicate intent found:" + name);
            }
            subCache.put(name, (Intent)definition);
        } else if (definition instanceof PolicySet) {
            QName name;
            Map<QName, PolicySet> subCache = this.getSubCache(PolicySet.class);
            if (subCache.containsKey(name = definition.getName())) {
                throw new PolicyActivationException("Duplicate policy set found:" + name);
            }
            subCache.put(name, (PolicySet)definition);
        } else if (definition instanceof BindingType) {
            QName name;
            Map<QName, BindingType> subCache = this.getSubCache(BindingType.class);
            if (subCache.containsKey(name = definition.getName())) {
                throw new PolicyActivationException("Duplicate binding type found:" + name);
            }
            subCache.put(name, (BindingType)definition);
        } else if (definition instanceof ImplementationType) {
            QName name;
            Map<QName, ImplementationType> subCache = this.getSubCache(ImplementationType.class);
            if (subCache.containsKey(name = definition.getName())) {
                throw new PolicyActivationException("Duplicate implementation type found:" + name);
            }
            subCache.put(name, (ImplementationType)definition);
        }
    }

    public void deactivateDefinitions(List<URI> contributionUris) throws PolicyActivationException {
        for (URI uri : contributionUris) {
            Contribution contribution = this.metaDataStore.find(uri);
            for (Resource resource : contribution.getResources()) {
                for (ResourceElement resourceElement : resource.getResourceElements()) {
                    Object value = resourceElement.getValue();
                    if (!(value instanceof AbstractPolicyDefinition)) continue;
                    this.deactivate((AbstractPolicyDefinition)value);
                }
            }
        }
    }

    public void deactivate(AbstractPolicyDefinition definition) throws PolicyActivationException {
        if (definition instanceof Intent) {
            this.getSubCache(Intent.class).remove(definition.getName());
        } else if (definition instanceof PolicySet) {
            this.getSubCache(PolicySet.class).remove(definition.getName());
        } else if (definition instanceof BindingType) {
            this.getSubCache(BindingType.class).remove(definition.getName());
        } else if (definition instanceof ImplementationType) {
            this.getSubCache(ImplementationType.class).remove(definition.getName());
        }
    }

    private <D extends AbstractPolicyDefinition> Map<QName, D> getSubCache(Class<D> definitionClass) {
        return this.cache.get(definitionClass);
    }
}

