/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.io.IOException;
import java.net.URI;
import javax.management.MBeanServer;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.contribution.MetaDataStoreImpl;
import org.fabric3.contribution.ProcessorRegistryImpl;
import org.fabric3.fabric.channel.ChannelConnectionImpl;
import org.fabric3.fabric.channel.ChannelImpl;
import org.fabric3.fabric.channel.ChannelManagerImpl;
import org.fabric3.fabric.channel.EventStreamImpl;
import org.fabric3.fabric.channel.SyncFanOutHandler;
import org.fabric3.fabric.classloader.ClassLoaderRegistryImpl;
import org.fabric3.fabric.cm.ComponentManagerImpl;
import org.fabric3.fabric.component.scope.CompositeScopeContainer;
import org.fabric3.fabric.component.scope.ScopeContainerMonitor;
import org.fabric3.fabric.component.scope.ScopeRegistryImpl;
import org.fabric3.fabric.lcm.LogicalComponentManagerImpl;
import org.fabric3.fabric.repository.RepositoryImpl;
import org.fabric3.fabric.runtime.RuntimeServices;
import org.fabric3.host.Names;
import org.fabric3.host.monitor.MonitorCreationException;
import org.fabric3.host.monitor.MonitorEventDispatcher;
import org.fabric3.host.monitor.MonitorProxyService;
import org.fabric3.host.monitor.Monitorable;
import org.fabric3.host.repository.Repository;
import org.fabric3.host.repository.RepositoryException;
import org.fabric3.host.runtime.Fabric3Runtime;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.runtime.InitializationException;
import org.fabric3.host.runtime.RuntimeConfiguration;
import org.fabric3.host.runtime.ShutdownException;
import org.fabric3.monitor.runtime.JDKMonitorProxyService;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.channel.RegistrationException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.fabric3.spi.monitor.DispatcherWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntime
implements Fabric3Runtime,
RuntimeServices {
    private HostInfo hostInfo;
    private MonitorProxyService monitorService;
    private LogicalComponentManager logicalComponentManager;
    private ComponentManager componentManager;
    private ChannelManager channelManager;
    private CompositeScopeContainer scopeContainer;
    private ClassLoaderRegistry classLoaderRegistry;
    private MetaDataStore metaDataStore;
    private ScopeRegistry scopeRegistry;
    private MBeanServer mbServer;
    private MonitorEventDispatcher runtimeDispatcher;
    private MonitorEventDispatcher appDispatcher;
    private Repository repository;
    private MonitorLevel level = MonitorLevel.INFO;

    protected AbstractRuntime(RuntimeConfiguration configuration) {
        this.hostInfo = configuration.getHostInfo();
        this.mbServer = configuration.getMBeanServer();
        this.runtimeDispatcher = configuration.getRuntimeDispatcher();
        this.appDispatcher = configuration.getAppDispatcher();
        this.repository = configuration.getRepository();
    }

    @Override
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    @Override
    public MonitorProxyService getMonitorProxyService() {
        return this.monitorService;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbServer;
    }

    public String getName() {
        return "fabric3://runtime";
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public void boot() throws InitializationException {
        ScopeContainerMonitor monitor;
        this.logicalComponentManager = new LogicalComponentManagerImpl();
        this.componentManager = new ComponentManagerImpl();
        this.channelManager = new ChannelManagerImpl();
        QName deployable = new QName("urn:fabric3.org:core", "boot");
        this.runtimeDispatcher.start();
        this.registerChannel(Names.RUNTIME_MONITOR_CHANNEL_URI, deployable, this.runtimeDispatcher);
        this.appDispatcher.start();
        this.registerChannel(Names.APPLICATION_MONITOR_CHANNEL_URI, deployable, this.appDispatcher);
        this.classLoaderRegistry = new ClassLoaderRegistryImpl();
        ProcessorRegistryImpl processorRegistry = new ProcessorRegistryImpl();
        this.metaDataStore = new MetaDataStoreImpl((ProcessorRegistry)processorRegistry);
        this.monitorService = new JDKMonitorProxyService((Monitorable)this, this.channelManager);
        try {
            monitor = (ScopeContainerMonitor)this.monitorService.createMonitor(ScopeContainerMonitor.class, Names.RUNTIME_MONITOR_CHANNEL_URI);
        }
        catch (MonitorCreationException e) {
            throw new InitializationException((Throwable)e);
        }
        this.scopeContainer = new CompositeScopeContainer(monitor);
        this.scopeContainer.start();
        this.scopeRegistry = new ScopeRegistryImpl();
        this.scopeRegistry.register((ScopeContainer)this.scopeContainer);
        if (this.repository == null) {
            this.repository = this.createRepository();
        }
    }

    private void registerChannel(URI name, QName deployable, MonitorEventDispatcher dispatcher) throws InitializationException {
        SyncFanOutHandler handler = new SyncFanOutHandler();
        ChannelImpl channel = new ChannelImpl(name, deployable, handler);
        ChannelConnectionImpl connection = new ChannelConnectionImpl();
        EventStreamImpl stream = new EventStreamImpl(new PhysicalEventStreamDefinition("dispatcher"));
        stream.addHandler((EventStreamHandler)new DispatcherWrapper(dispatcher));
        connection.addEventStream(stream);
        channel.subscribe(URI.create("Fabric3Dispatcher"), connection);
        try {
            this.channelManager.register((Channel)channel);
        }
        catch (RegistrationException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public void destroy() throws ShutdownException {
        WorkContext workContext = new WorkContext();
        this.scopeContainer.stopAllContexts(workContext);
        try {
            this.repository.shutdown();
        }
        catch (RepositoryException e) {
            throw new ShutdownException((Throwable)e);
        }
        this.runtimeDispatcher.stop();
    }

    public <I> I getComponent(Class<I> service, URI uri) {
        if (RuntimeServices.class.equals(service)) {
            return service.cast(this);
        }
        AtomicComponent component = (AtomicComponent)this.componentManager.getComponent(uri);
        if (component == null) {
            return null;
        }
        WorkContext workContext = new WorkContext();
        WorkContext oldContext = WorkContextTunnel.setThreadWorkContext((WorkContext)workContext);
        try {
            InstanceWrapper wrapper = this.scopeContainer.getWrapper(component, workContext);
            I i = service.cast(wrapper.getInstance());
            return i;
        }
        catch (InstanceLifecycleException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            WorkContextTunnel.setThreadWorkContext((WorkContext)oldContext);
        }
    }

    @Override
    public LogicalComponentManager getLogicalComponentManager() {
        return this.logicalComponentManager;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public ScopeContainer getScopeContainer() {
        return this.scopeContainer;
    }

    @Override
    public ClassLoaderRegistry getClassLoaderRegistry() {
        return this.classLoaderRegistry;
    }

    @Override
    public MetaDataStore getMetaDataStore() {
        return this.metaDataStore;
    }

    @Override
    public ScopeRegistry getScopeRegistry() {
        return this.scopeRegistry;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    protected Repository createRepository() throws InitializationException {
        try {
            RepositoryImpl repository = new RepositoryImpl(this.hostInfo);
            repository.init();
            return repository;
        }
        catch (IOException e) {
            throw new InitializationException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InitializationException((Throwable)e);
        }
    }
}

