/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.io.File;
import java.net.URI;
import org.fabric3.fabric.runtime.DefaultCoordinator;
import org.fabric3.fabric.runtime.DefaultRuntime;
import org.fabric3.fabric.runtime.bootstrap.RepositoryScanner;
import org.fabric3.fabric.runtime.bootstrap.SystemConfigLoader;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.monitor.MonitorConfigurationException;
import org.fabric3.host.monitor.MonitorEventDispatcher;
import org.fabric3.host.runtime.BootConfiguration;
import org.fabric3.host.runtime.BootstrapService;
import org.fabric3.host.runtime.Fabric3Runtime;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.runtime.JmxConfiguration;
import org.fabric3.host.runtime.ParseException;
import org.fabric3.host.runtime.RuntimeConfiguration;
import org.fabric3.host.runtime.RuntimeCoordinator;
import org.fabric3.host.runtime.ScanException;
import org.fabric3.host.runtime.ScanResult;
import org.fabric3.host.stream.Source;
import org.fabric3.monitor.runtime.LogbackDispatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultBootstrapService
implements BootstrapService {
    private RepositoryScanner scanner = new RepositoryScanner();
    private SystemConfigLoader systemConfigLoader = new SystemConfigLoader();

    public Document loadSystemConfig(File configDirectory) throws ParseException {
        return this.systemConfigLoader.loadSystemConfig(configDirectory);
    }

    public Document loadSystemConfig(Source source) throws ParseException {
        return this.systemConfigLoader.loadSystemConfig(source);
    }

    public Document createDefaultSystemConfig() {
        return this.systemConfigLoader.createDefaultSystemConfig();
    }

    public URI parseDomainName(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseDomainName(systemConfig);
    }

    public RuntimeMode parseRuntimeMode(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseRuntimeMode(systemConfig);
    }

    public JmxConfiguration parseJmxConfiguration(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseJmxConfiguration(systemConfig);
    }

    public MonitorEventDispatcher createMonitorDispatcher(String elementName, Document systemConfig) throws MonitorConfigurationException {
        boolean additive = !"application.monitor".equals(elementName);
        LogbackDispatcher dispatcher = new LogbackDispatcher(elementName, additive);
        Element element = this.systemConfigLoader.getMonitorConfiguration(elementName, systemConfig);
        if (element != null) {
            dispatcher.configure(element);
        }
        return dispatcher;
    }

    public ScanResult scanRepository(HostInfo info) throws ScanException {
        return this.scanner.scan(info);
    }

    public Fabric3Runtime createDefaultRuntime(RuntimeConfiguration configuration) {
        return new DefaultRuntime(configuration);
    }

    public RuntimeCoordinator createCoordinator(BootConfiguration configuration) {
        return new DefaultCoordinator(configuration);
    }
}

