/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.net.URI;
import java.util.List;
import org.fabric3.fabric.runtime.DefaultBootstrapper;
import org.fabric3.fabric.runtime.ExtensionInitializationException;
import org.fabric3.fabric.runtime.FabricNames;
import org.fabric3.host.Names;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.host.runtime.BootConfiguration;
import org.fabric3.host.runtime.Fabric3Runtime;
import org.fabric3.host.runtime.InitializationException;
import org.fabric3.host.runtime.RuntimeCoordinator;
import org.fabric3.host.runtime.RuntimeState;
import org.fabric3.host.runtime.ShutdownException;
import org.fabric3.spi.event.DomainRecover;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.ExtensionsInitialized;
import org.fabric3.spi.event.Fabric3Event;
import org.fabric3.spi.event.JoinDomain;
import org.fabric3.spi.event.RuntimeRecover;
import org.fabric3.spi.event.RuntimeStart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCoordinator
implements RuntimeCoordinator {
    private RuntimeState state = RuntimeState.UNINITIALIZED;
    private BootConfiguration configuration;
    private Fabric3Runtime runtime;

    public DefaultCoordinator(BootConfiguration configuration) {
        this.configuration = configuration;
        this.runtime = configuration.getRuntime();
    }

    public RuntimeState getState() {
        return this.state;
    }

    public void start() throws InitializationException {
        this.runtime.boot();
        DefaultBootstrapper bootstrapper = new DefaultBootstrapper(this.configuration);
        bootstrapper.bootRuntimeDomain();
        bootstrapper.bootSystem();
        this.loadExtensions();
        EventService eventService = (EventService)this.runtime.getComponent(EventService.class, FabricNames.EVENT_SERVICE_URI);
        eventService.publish((Fabric3Event)new ExtensionsInitialized());
        this.recover(eventService);
        eventService.publish((Fabric3Event)new JoinDomain());
        eventService.publish((Fabric3Event)new DomainRecover());
        eventService.publish((Fabric3Event)new RuntimeStart());
        this.state = RuntimeState.STARTED;
    }

    public void shutdown() throws ShutdownException {
        if (this.state == RuntimeState.STARTED) {
            this.runtime.destroy();
        }
        this.state = RuntimeState.SHUTDOWN;
    }

    private void loadExtensions() throws InitializationException {
        List contributions = this.configuration.getExtensionContributions();
        List<URI> uris = this.installContributions(contributions);
        this.deploy(uris);
    }

    private void recover(EventService eventService) throws InitializationException {
        Domain domain = (Domain)this.runtime.getComponent(Domain.class, Names.APPLICATION_DOMAIN_URI);
        if (domain == null) {
            this.state = RuntimeState.ERROR;
            String name = Names.APPLICATION_DOMAIN_URI.toString();
            throw new InitializationException("Domain not found: " + name);
        }
        List contributions = this.configuration.getUserContributions();
        this.installContributions(contributions);
        eventService.publish((Fabric3Event)new RuntimeRecover());
    }

    private List<URI> installContributions(List<ContributionSource> sources) throws InitializationException {
        try {
            ContributionService contributionService = (ContributionService)this.runtime.getComponent(ContributionService.class, Names.CONTRIBUTION_SERVICE_URI);
            return contributionService.contribute(sources);
        }
        catch (ContributionException e) {
            this.state = RuntimeState.ERROR;
            throw new ExtensionInitializationException("Error contributing extensions", e);
        }
    }

    private void deploy(List<URI> contributionUris) throws InitializationException {
        try {
            Domain domain = (Domain)this.runtime.getComponent(Domain.class, Names.RUNTIME_DOMAIN_SERVICE_URI);
            domain.include(contributionUris);
        }
        catch (DeploymentException e) {
            this.state = RuntimeState.ERROR;
            throw new ExtensionInitializationException("Error deploying extensions", e);
        }
    }
}

