/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.runtime.bootstrap.BootstrapLoaderFactory;
import org.fabric3.fabric.xml.XMLFactoryImpl;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.runtime.InitializationException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.CompositeImplementation;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.fabric3.spi.introspection.validation.InvalidCompositeException;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.fabric3.spi.xml.XMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapCompositeFactory {
    private static final XMLFactory XML_FACTORY = new XMLFactoryImpl();

    private BootstrapCompositeFactory() {
    }

    public static Composite createSystemComposite(URL compositeUrl, Contribution contribution, ClassLoader bootClassLoader, ImplementationProcessor<SystemImplementation> processor) throws InitializationException {
        try {
            Loader loader = BootstrapLoaderFactory.createLoader(processor, XML_FACTORY);
            URI contributionUri = contribution.getUri();
            DefaultIntrospectionContext introspectionContext = new DefaultIntrospectionContext(contributionUri, bootClassLoader, compositeUrl);
            UrlSource source = new UrlSource(compositeUrl);
            Composite composite = (Composite)loader.load((Source)source, Composite.class, (IntrospectionContext)introspectionContext);
            if (introspectionContext.hasErrors()) {
                QName name = composite.getName();
                List errors = introspectionContext.getErrors();
                List warnings = introspectionContext.getWarnings();
                throw new InvalidCompositeException(name, errors, warnings);
            }
            BootstrapCompositeFactory.addContributionUri(contributionUri, composite);
            BootstrapCompositeFactory.addResource(contribution, composite, compositeUrl);
            return composite;
        }
        catch (ContributionException e) {
            throw new InitializationException((Throwable)e);
        }
        catch (LoaderException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    private static void addContributionUri(URI contributionUri, Composite composite) {
        composite.setContributionUri(contributionUri);
        for (ComponentDefinition definition : composite.getComponents().values()) {
            Implementation implementation = definition.getImplementation();
            if (CompositeImplementation.class.isInstance(implementation)) {
                CompositeImplementation compositeImplementation = (CompositeImplementation)CompositeImplementation.class.cast(implementation);
                Composite componentType = (Composite)compositeImplementation.getComponentType();
                BootstrapCompositeFactory.addContributionUri(contributionUri, componentType);
                continue;
            }
            definition.setContributionUri(contributionUri);
        }
    }

    private static void addResource(Contribution contribution, Composite composite, URL scdlLocation) {
        UrlSource source = new UrlSource(scdlLocation);
        Resource resource = new Resource((Source)source, "text/vnd.fabric3.composite+xml");
        QName compositeName = composite.getName();
        QNameSymbol symbol = new QNameSymbol(compositeName);
        ResourceElement element = new ResourceElement((Symbol)symbol, (Object)composite);
        resource.addResourceElement(element);
        resource.setProcessed(true);
        contribution.addResource(resource);
    }
}

