/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.contribution.FileContributionSource;
import org.fabric3.host.contribution.SyntheticContributionSource;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.runtime.ScanException;
import org.fabric3.host.runtime.ScanResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryScanner {
    public ScanResult scan(HostInfo info) throws ScanException {
        List<ContributionSource> extensionSources = this.scan(info.getExtensionsRepositoryDirectory(), true);
        List<ContributionSource> runtimeSources = this.scan(info.getRuntimeRepositoryDirectory(), true);
        extensionSources.addAll(runtimeSources);
        List<ContributionSource> userSource = this.scan(info.getUserRepositoryDirectory(), false);
        return new ScanResult(extensionSources, userSource);
    }

    public List<ContributionSource> scan(File directory, boolean extension) throws ScanException {
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getName().startsWith(".");
            }
        });
        ArrayList<ContributionSource> sources = new ArrayList<ContributionSource>();
        for (File file : files) {
            try {
                FileContributionSource source;
                URI uri;
                URL location = file.toURI().toURL();
                if (file.isDirectory()) {
                    uri = URI.create("f3-" + file.getName());
                    source = new SyntheticContributionSource(uri, location, extension);
                } else {
                    uri = URI.create(file.getName());
                    source = new FileContributionSource(uri, location, -1L, extension);
                }
                sources.add((ContributionSource)source);
            }
            catch (MalformedURLException e) {
                throw new ScanException("Error loading contribution:" + file.getName(), (Throwable)e);
            }
        }
        return sources;
    }
}

