/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fabric3.fabric.xml.DocumentLoader;
import org.fabric3.fabric.xml.DocumentLoaderImpl;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.monitor.MonitorConfigurationException;
import org.fabric3.host.runtime.JmxConfiguration;
import org.fabric3.host.runtime.ParseException;
import org.fabric3.host.security.JmxSecurity;
import org.fabric3.host.security.Role;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemConfigLoader {
    private static final URI DEFAULT_DOMAIN = URI.create("fabric3://domain");
    private static final int DEFAULT_JMX_PORT = 1199;
    private DocumentLoader loader = new DocumentLoaderImpl();

    public Document loadSystemConfig(File configDirectory) throws ParseException {
        File systemConfig = new File(configDirectory, "systemConfig.xml");
        if (systemConfig.exists()) {
            try {
                URL url = systemConfig.toURI().toURL();
                UrlSource source = new UrlSource(url);
                return this.loadSystemConfig((Source)source);
            }
            catch (MalformedURLException e) {
                throw new ParseException((Throwable)e);
            }
        }
        return this.createDefaultSystemConfig();
    }

    public Document loadSystemConfig(Source source) throws ParseException {
        try {
            InputSource inputSource = new InputSource(source.openStream());
            Document document = this.loader.load(inputSource, true);
            Element oldRoot = document.getDocumentElement();
            Element newRoot = document.createElement("values");
            document.removeChild(oldRoot);
            document.appendChild(newRoot);
            newRoot.appendChild(oldRoot);
            return document;
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public Document createDefaultSystemConfig() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().newDocument();
            Element root = document.createElement("values");
            document.appendChild(root);
            Element config = document.createElement("config");
            root.appendChild(config);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public URI parseDomainName(Document systemConfig) throws ParseException {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            String name = node.getAttribute("domain");
            if (name.length() > 0) {
                try {
                    URI uri = new URI("fabric3://" + name);
                    if (uri.getHost() == null) {
                        throw new ParseException("Invalid domain name specified in system configuration. Domain names must be a valid URI host.");
                    }
                    return uri;
                }
                catch (URISyntaxException e) {
                    throw new ParseException("Invalid domain name specified in system configuration", (Throwable)e);
                }
            }
            return DEFAULT_DOMAIN;
        }
        if (nodes.getLength() == 0) {
            return DEFAULT_DOMAIN;
        }
        throw new ParseException("Invalid system configuration: more than one <runtime> element specified");
    }

    public RuntimeMode parseRuntimeMode(Document systemConfig) throws ParseException {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            String name = node.getAttribute("mode");
            if ("controller".equalsIgnoreCase(name)) {
                return RuntimeMode.CONTROLLER;
            }
            if ("participant".equalsIgnoreCase(name)) {
                return RuntimeMode.PARTICIPANT;
            }
        }
        return RuntimeMode.VM;
    }

    public JmxConfiguration parseJmxConfiguration(Document systemConfig) throws ParseException {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            JmxSecurity security = this.parseSecurity(node);
            Set<Role> roles = this.parseRoles(node);
            String ports = node.getAttribute("jmxPort");
            if (ports.length() == 0) {
                ports = node.getAttribute("jmx.port");
            }
            if (ports.length() > 0) {
                int maxPort;
                int minPort;
                String[] tokens = ports.split("-");
                if (tokens.length == 1) {
                    maxPort = minPort = this.parsePortNumber(ports);
                } else if (tokens.length == 2) {
                    minPort = this.parsePortNumber(tokens[0]);
                    maxPort = this.parsePortNumber(tokens[1]);
                } else {
                    throw new ParseException("Invalid JMX port specified in system configuration: " + ports);
                }
                return new JmxConfiguration(security, roles, minPort, maxPort);
            }
            return new JmxConfiguration(security, roles, 1199, 1199);
        }
        if (nodes.getLength() == 0) {
            return new JmxConfiguration(JmxSecurity.DISABLED, Collections.emptySet(), 1199, 1199);
        }
        throw new ParseException("Invalid system configuration: more than one <runtime> element specified");
    }

    public Element getMonitorConfiguration(String elementName, Document systemConfig) throws MonitorConfigurationException {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = "ROOT".equals(elementName) ? root.getElementsByTagName("runtime.monitor") : root.getElementsByTagName(elementName);
        if (nodes.getLength() == 1) {
            Element monitorElement = (Element)nodes.item(0);
            NodeList configurationElements = monitorElement.getElementsByTagName("configuration");
            if (configurationElements.getLength() != 1) {
                throw new MonitorConfigurationException("Invalid system configuration: Only one monitor <configuration> element must be specified");
            }
            Element element = (Element)configurationElements.item(0);
            this.addAppenderReferences(systemConfig, elementName, element);
            return element;
        }
        if (nodes.getLength() == 0) {
            return null;
        }
        throw new MonitorConfigurationException("Invalid system configuration: more than one <monitor> element specified");
    }

    private void addAppenderReferences(Document systemConfig, String loggerName, Element element) {
        NodeList elements = element.getElementsByTagName("appender");
        ArrayList<Element> added = new ArrayList<Element>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            Node nameAttribute = node.getAttributes().getNamedItem("name");
            if (nameAttribute == null) continue;
            String name = nameAttribute.getNodeValue();
            Element reference = systemConfig.createElement("appender-ref");
            reference.setAttribute("ref", name);
            added.add(reference);
        }
        if (!added.isEmpty()) {
            Element root = systemConfig.createElement("logger");
            root.setAttribute("name", loggerName);
            element.appendChild(root);
            for (Element reference : added) {
                root.appendChild(reference);
            }
        }
    }

    private int parsePortNumber(String portVal) {
        int port;
        try {
            port = Integer.parseInt(portVal);
            if (port < 0) {
                throw new IllegalArgumentException("Invalid JMX port number specified in runtime.properties:" + port);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid JMX port", e);
        }
        return port;
    }

    private Set<Role> parseRoles(Element node) {
        String[] rolesString = node.getAttribute("jmx.access.roles").split(",");
        HashSet<Role> roles = new HashSet<Role>();
        for (String s : rolesString) {
            roles.add(new Role(s.trim()));
        }
        return roles;
    }

    private JmxSecurity parseSecurity(Element node) throws ParseException {
        String securityString = node.getAttribute("jmx.security");
        if (securityString.length() > 0) {
            try {
                return JmxSecurity.valueOf((String)securityString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Invalid JMX security setting:" + securityString);
            }
        }
        return JmxSecurity.DISABLED;
    }
}

