/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;

public class SafeInputStream
extends InputStream {
    private JarFile jarFile;
    private InputStream is;

    public SafeInputStream(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (protocol != null && protocol.equals("jar")) {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            connection.setUseCaches(false);
            this.is = connection.getInputStream();
            this.jarFile = connection.getJarFile();
        } else {
            this.is = url.openStream();
        }
    }

    public SafeInputStream(JarURLConnection connection) throws IOException {
        connection.setUseCaches(false);
        this.is = connection.getInputStream();
        this.jarFile = connection.getJarFile();
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public int read() throws IOException {
        return this.is.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }
}

