/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.recovery.domain;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.recovery.domain.FSDomainReplayMonitor;
import org.fabric3.spi.event.DomainRecover;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.xml.XMLFactory;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class FSDomainReplayer
implements Fabric3EventListener<DomainRecover> {
    private static final QName DEPLOYABLE = new QName("urn:fabric3.org:core", "deployable");
    private EventService eventService;
    private FSDomainReplayMonitor monitor;
    private XMLInputFactory inputFactory;
    private File domainLog;
    private Domain domain;

    public FSDomainReplayer(@Reference(name="domain") Domain domain, @Reference XMLFactory xmlFactory, @Reference HostInfo hostInfo, @Reference EventService eventService, @Monitor FSDomainReplayMonitor monitor) {
        this.domain = domain;
        this.eventService = eventService;
        this.monitor = monitor;
        this.inputFactory = xmlFactory.newInputFactoryInstance();
        this.domainLog = new File(hostInfo.getDataDir(), "domain.xml");
    }

    @Init
    public void init() {
        this.eventService.subscribe(DomainRecover.class, (Fabric3EventListener)this);
    }

    public void onEvent(DomainRecover event) {
        if (!this.domainLog.exists()) {
            return;
        }
        try {
            Map<QName, String> deployables = this.parse();
            this.domain.recover(deployables);
        }
        catch (FileNotFoundException e) {
            this.monitor.error(e);
        }
        catch (XMLStreamException e) {
            this.monitor.error(e);
        }
        catch (DeploymentException e) {
            this.monitor.error(e);
        }
    }

    private Map<QName, String> parse() throws FileNotFoundException, XMLStreamException {
        FileInputStream fis = new FileInputStream(this.domainLog);
        BufferedInputStream stream = new BufferedInputStream(fis);
        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(stream);
        LinkedHashMap<QName, String> deployables = new LinkedHashMap<QName, String>();
        try {
            block12: while (true) {
                switch (reader.next()) {
                    case 1: {
                        if (!DEPLOYABLE.equals(reader.getName())) break;
                        String namespace = reader.getAttributeValue(null, "namespace");
                        if (namespace == null) {
                            Location location = reader.getLocation();
                            int line = location.getLineNumber();
                            int col = location.getColumnNumber();
                            this.monitor.errorMessage("Namespace attribute missing in domain journal [" + line + "," + col + "]");
                            continue block12;
                        }
                        String name = reader.getAttributeValue(null, "name");
                        if (name == null) {
                            Location location = reader.getLocation();
                            int line = location.getLineNumber();
                            int col = location.getColumnNumber();
                            this.monitor.errorMessage("Name attribute missing in domain journal [" + line + "," + col + "]");
                            continue block12;
                        }
                        String plan = reader.getAttributeValue(null, "plan");
                        QName qName = new QName(namespace, name);
                        deployables.put(qName, plan);
                        break;
                    }
                    case 8: {
                        LinkedHashMap<QName, String> linkedHashMap = deployables;
                        return linkedHashMap;
                    }
                }
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }
}

