/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.recovery.domain;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.recovery.domain.FSDomainTrackerMonitor;
import org.fabric3.spi.domain.DomainListener;
import org.fabric3.spi.xml.XMLFactory;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class FSDomainTracker
implements DomainListener {
    private static final String NO_PLAN = "";
    private File domainLog;
    private XMLOutputFactory outputFactory;
    private FSDomainTrackerMonitor monitor;
    private Map<QName, String> deployables;

    public FSDomainTracker(@Reference XMLFactory factory, @Reference HostInfo info, @Monitor FSDomainTrackerMonitor monitor) {
        this.monitor = monitor;
        this.outputFactory = factory.newOutputFactoryInstance();
        this.deployables = new HashMap<QName, String>();
        this.domainLog = new File(info.getDataDir(), "domain.xml");
    }

    public void onInclude(QName included, String plan) {
        if (plan == null) {
            plan = NO_PLAN;
        }
        this.deployables.put(included, plan);
        this.persist();
    }

    public void onUndeploy(QName undeployed) {
        this.deployables.remove(undeployed);
        this.persist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        FilterOutputStream stream = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.domainLog);
            stream = new BufferedOutputStream(fos);
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(stream);
            writer.writeStartDocument();
            writer.writeStartElement("domain");
            writer.writeDefaultNamespace("urn:fabric3.org:core");
            for (Map.Entry<QName, String> entry : this.deployables.entrySet()) {
                QName deployable = entry.getKey();
                String plan = entry.getValue();
                writer.writeStartElement("deployable");
                writer.writeAttribute("namespace", deployable.getNamespaceURI());
                writer.writeAttribute("name", deployable.getLocalPart());
                if (plan != NO_PLAN) {
                    writer.writeAttribute("plan", plan);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (FileNotFoundException e) {
            this.monitor.error(e);
        }
        catch (XMLStreamException e) {
            this.monitor.error(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

