/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk;

import java.lang.reflect.Method;
import java.util.Map;
import org.fabric3.implementation.pojo.builder.ProxyCreationException;
import org.fabric3.implementation.pojo.builder.WireProxyService;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.wire.InvocationChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackWireObjectFactory<T>
implements ObjectFactory<T> {
    private ScopeContainer container;
    private WireProxyService proxyService;
    private Map<String, Map<Method, InvocationChain>> mappings;
    private Class<T> interfaze;

    public CallbackWireObjectFactory(Class<T> interfaze, ScopeContainer container, WireProxyService proxyService, Map<String, Map<Method, InvocationChain>> mappings) {
        this.interfaze = interfaze;
        this.container = container;
        this.proxyService = proxyService;
        this.mappings = mappings;
    }

    public T getInstance() throws ObjectCreationException {
        if (Scope.COMPOSITE.equals((Object)this.container.getScope())) {
            try {
                return this.interfaze.cast(this.proxyService.createCallbackProxy(this.interfaze, this.mappings));
            }
            catch (ProxyCreationException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        CallFrame frame = WorkContextTunnel.getThreadWorkContext().peekCallFrame();
        String callbackUri = frame.getCallbackUri();
        assert (callbackUri != null);
        Map<Method, InvocationChain> mapping = this.mappings.get(callbackUri);
        assert (mapping != null);
        return this.interfaze.cast(this.proxyService.createStatefullCallbackProxy(this.interfaze, mapping, this.container));
    }

    public Class<T> getInterfaze() {
        return this.interfaze;
    }

    public void updateMappings(String callbackUri, Map<Method, InvocationChain> chains) {
        this.mappings.put(callbackUri, chains);
    }
}

