/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.federation;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.fabric3.runtime.weblogic.cluster.ChannelException;
import org.fabric3.runtime.weblogic.cluster.RuntimeChannel;
import org.fabric3.runtime.weblogic.federation.WebLogicTopologyMonitor;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.command.Response;
import org.fabric3.spi.command.ResponseCommand;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;

public class RuntimeChannelImpl
implements RuntimeChannel {
    private String runtimeName;
    private CommandExecutorRegistry executorRegistry;
    private SerializationService serializationService;
    private WebLogicTopologyMonitor monitor;

    public RuntimeChannelImpl(String runtimeName, CommandExecutorRegistry executorRegistry, SerializationService serializationService, WebLogicTopologyMonitor monitor) {
        this.runtimeName = runtimeName;
        this.executorRegistry = executorRegistry;
        this.serializationService = serializationService;
        this.monitor = monitor;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public byte[] sendSynchronous(byte[] payload) throws RemoteException, ChannelException {
        try {
            ResponseCommand command = (ResponseCommand)this.serializationService.deserialize(ResponseCommand.class, payload);
            this.executorRegistry.execute((Command)command);
            Response response = command.getResponse();
            return this.serializationService.serialize((Serializable)response);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ChannelException((Throwable)e);
        }
        catch (ExecutionException e) {
            this.monitor.error(e);
            throw new ChannelException(e.getMessage());
        }
    }

    public void send(byte[] payload) throws RemoteException, ChannelException {
        try {
            Command command = (Command)this.serializationService.deserialize(Command.class, payload);
            this.executorRegistry.execute(command);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ChannelException((Throwable)e);
        }
        catch (ExecutionException e) {
            this.monitor.error(e);
            throw new ChannelException(e.getMessage());
        }
    }
}

