/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.federation;

import javax.management.JMException;
import org.fabric3.runtime.weblogic.federation.JmxHelper;
import org.fabric3.spi.allocator.AllocationException;
import org.fabric3.spi.allocator.Allocator;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.plan.DeploymentPlan;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class WebLogicAllocator
implements Allocator {
    private JmxHelper jmxHelper;
    private String domainName;

    public WebLogicAllocator(@Reference JmxHelper jmxHelper) {
        this.jmxHelper = jmxHelper;
    }

    @Init
    public void init() throws JMException {
        this.domainName = this.jmxHelper.getRuntimeJmxAttribute(String.class, "DomainConfiguration/Name");
    }

    public void allocate(LogicalComponent<?> component, DeploymentPlan plan) {
        component.setZone(this.domainName);
    }

    public void allocate(LogicalChannel channel, DeploymentPlan plan) {
        channel.setZone(this.domainName);
    }

    public void allocate(LogicalResource<?> resource, DeploymentPlan plan) throws AllocationException {
        resource.setZone(this.domainName);
    }
}

