/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.federation;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.runtime.weblogic.cluster.ChannelException;
import org.fabric3.runtime.weblogic.cluster.RuntimeChannel;
import org.fabric3.runtime.weblogic.federation.JndiHelper;
import org.fabric3.runtime.weblogic.federation.RuntimeChannelImpl;
import org.fabric3.runtime.weblogic.federation.WebLogicTopologyMonitor;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.command.Response;
import org.fabric3.spi.command.ResponseCommand;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.event.JoinDomain;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.federation.DomainTopologyService;
import org.fabric3.spi.federation.MessageException;
import org.fabric3.spi.federation.RuntimeInstance;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value=DomainTopologyService.class)
@EagerInit
public class WebLogicDomainTopologyService
implements DomainTopologyService {
    private String runtimeName = "controller";
    private CommandExecutorRegistry executorRegistry;
    private EventService eventService;
    private SerializationService serializationService;
    private WebLogicTopologyMonitor monitor;
    private InitialContext rootContext;
    private EventContext participantContext;

    public WebLogicDomainTopologyService(@Reference CommandExecutorRegistry executorRegistry, @Reference EventService eventService, @Reference SerializationService serializationService, @Monitor WebLogicTopologyMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.eventService = eventService;
        this.serializationService = serializationService;
        this.monitor = monitor;
    }

    @Init
    public void init() throws NamingException {
        this.eventService.subscribe(JoinDomain.class, (Fabric3EventListener)new JoinDomainListener());
    }

    @Destroy
    public void destroy() throws NamingException {
        if (this.rootContext != null) {
            this.rootContext.unbind("Fabric3ControllerChannel");
            this.rootContext.close();
        }
        if (this.participantContext != null) {
            this.participantContext.close();
        }
    }

    public List<String> getZones() {
        return null;
    }

    public List<RuntimeInstance> getRuntimes() {
        ArrayList<RuntimeInstance> instances = new ArrayList<RuntimeInstance>();
        try {
            NamingEnumeration<Binding> list = this.participantContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                String runtimeName = channel.getRuntimeName();
                RuntimeInstance runtimeInstance = new RuntimeInstance(runtimeName);
                instances.add(runtimeInstance);
            }
        }
        catch (NamingException e) {
            this.monitor.error(e);
        }
        catch (RemoteException e) {
            this.monitor.error(e);
        }
        return instances;
    }

    public String getTransportMetaData(String zone, String transport) {
        return null;
    }

    public void broadcast(Command command) throws MessageException {
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                channel.send(payload);
            }
        }
        catch (NamingException e) {
            throw new MessageException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MessageException((Throwable)e);
        }
        catch (ChannelException e) {
            throw new MessageException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
    }

    public void broadcast(String zoneName, Command command) throws MessageException {
        List<RuntimeChannel> channels = this.getChannels();
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            for (RuntimeChannel channel : channels) {
                channel.send(payload);
            }
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        catch (ChannelException e) {
            throw new MessageException((Throwable)e);
        }
    }

    public List<Response> sendSynchronousToZone(String zoneName, ResponseCommand command, boolean failFast, long timeout) throws MessageException {
        byte[] payload;
        List<RuntimeChannel> channels = this.getChannels();
        if (channels.isEmpty()) {
            throw new MessageException("No managed servers found to deploy to");
        }
        ArrayList<Response> responses = new ArrayList<Response>();
        try {
            payload = this.serializationService.serialize((Serializable)command);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        for (RuntimeChannel channel : channels) {
            try {
                byte[] responsePayload = channel.sendSynchronous(payload);
                Response response = (Response)this.serializationService.deserialize(Response.class, responsePayload);
                responses.add(response);
            }
            catch (ChannelException e) {
                throw new MessageException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new MessageException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new MessageException((Throwable)e);
            }
            catch (IOException e) {
                throw new MessageException((Throwable)e);
            }
        }
        return responses;
    }

    public Response sendSynchronous(String runtimeName, ResponseCommand command, long timeout) throws MessageException {
        try {
            RuntimeChannel runtimeChannel = null;
            NamingEnumeration<Binding> list = this.participantContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                if (!runtimeName.equals(channel.getRuntimeName())) continue;
                runtimeChannel = channel;
                break;
            }
            if (runtimeChannel == null) {
                throw new MessageException("Runtime not found: " + runtimeName);
            }
            byte[] payload = this.serializationService.serialize((Serializable)command);
            byte[] responsePayload = runtimeChannel.sendSynchronous(payload);
            return (Response)this.serializationService.deserialize(Response.class, responsePayload);
        }
        catch (ChannelException e) {
            throw new MessageException((Throwable)e);
        }
        catch (NamingException e) {
            throw new MessageException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MessageException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MessageException((Throwable)e);
        }
    }

    private List<RuntimeChannel> getChannels() throws MessageException {
        try {
            ArrayList<RuntimeChannel> channels = new ArrayList<RuntimeChannel>();
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                channels.add(channel);
            }
            return channels;
        }
        catch (NameNotFoundException e) {
            this.monitor.noManagedServers();
            return Collections.emptyList();
        }
        catch (NamingException e) {
            throw new MessageException((Throwable)e);
        }
    }

    private class ParticipantContextListener
    implements NamespaceChangeListener {
        private ParticipantContextListener() {
        }

        public void namingExceptionThrown(NamingExceptionEvent evt) {
        }

        public void objectAdded(NamingEvent evt) {
        }

        public void objectRemoved(NamingEvent evt) {
        }

        public void objectRenamed(NamingEvent evt) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinDomainListener
    implements Fabric3EventListener<JoinDomain> {
        private JoinDomainListener() {
        }

        public void onEvent(JoinDomain event) {
            try {
                RuntimeChannelImpl controllerChannel = new RuntimeChannelImpl(WebLogicDomainTopologyService.this.runtimeName, WebLogicDomainTopologyService.this.executorRegistry, WebLogicDomainTopologyService.this.serializationService, WebLogicDomainTopologyService.this.monitor);
                WebLogicDomainTopologyService.this.rootContext = new InitialContext();
                Context controllerContext = JndiHelper.getContext("Fabric3ControllerContext", WebLogicDomainTopologyService.this.rootContext);
                try {
                    controllerContext.bind("Fabric3ControllerChannel", (Object)controllerChannel);
                }
                catch (NameAlreadyBoundException e) {
                    controllerContext.rebind("Fabric3ControllerChannel", (Object)controllerChannel);
                }
                Context ctx = JndiHelper.getContext("Fabric3Participants", WebLogicDomainTopologyService.this.rootContext);
                assert (ctx instanceof EventContext);
                WebLogicDomainTopologyService.this.participantContext = (EventContext)ctx;
            }
            catch (NamingException e) {
                WebLogicDomainTopologyService.this.monitor.errorMessage("Error initializing domain topology service", e);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

