/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.federation;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.management.JMException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.command.RuntimeUpdateCommand;
import org.fabric3.federation.deployment.command.RuntimeUpdateResponse;
import org.fabric3.runtime.weblogic.cluster.ChannelException;
import org.fabric3.runtime.weblogic.cluster.RuntimeChannel;
import org.fabric3.runtime.weblogic.federation.JmxHelper;
import org.fabric3.runtime.weblogic.federation.JndiHelper;
import org.fabric3.runtime.weblogic.federation.RuntimeChannelImpl;
import org.fabric3.runtime.weblogic.federation.WebLogicTopologyMonitor;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.command.Response;
import org.fabric3.spi.command.ResponseCommand;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.event.JoinDomain;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.federation.MessageException;
import org.fabric3.spi.federation.TopologyListener;
import org.fabric3.spi.federation.ZoneTopologyService;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value=ZoneTopologyService.class)
@EagerInit
public class WebLogicZoneTopologyService
implements ZoneTopologyService {
    private static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private ExecutorService executorService;
    private WebLogicTopologyMonitor monitor;
    private EventService eventService;
    private SerializationService serializationService;
    private CommandExecutorRegistry executorRegistry;
    private JmxHelper jmxHelper;
    private RuntimeChannel runtimeChannel;
    private RuntimeChannel controllerChannel;
    private String runtimeName;
    private String adminServerUrl = "t3://localhost:7001";
    private boolean synchronize = true;
    private String zoneName;

    public WebLogicZoneTopologyService(@Reference EventService eventService, @Reference SerializationService serializationService, @Reference CommandExecutorRegistry executorRegistry, @Reference ExecutorService executorService, @Reference JmxHelper jmxHelper, @Monitor WebLogicTopologyMonitor monitor) {
        this.eventService = eventService;
        this.serializationService = serializationService;
        this.executorRegistry = executorRegistry;
        this.jmxHelper = jmxHelper;
        this.executorService = executorService;
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setAdminServerUrl(String adminServerUrl) {
        this.adminServerUrl = adminServerUrl;
    }

    @Property(required=false)
    public void setSynchronize(boolean synchronize) {
        this.synchronize = synchronize;
    }

    @Init
    public void init() throws JMException {
        this.runtimeName = this.jmxHelper.getRuntimeJmxAttribute(String.class, "ServerRuntime/Name");
        this.zoneName = this.jmxHelper.getRuntimeJmxAttribute(String.class, "DomainConfiguration/Name");
        this.eventService.subscribe(JoinDomain.class, (Fabric3EventListener)new JoinDomainListener());
        this.runtimeChannel = new RuntimeChannelImpl(this.runtimeName, this.executorRegistry, this.serializationService, this.monitor);
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public void register(TopologyListener listener) {
    }

    public void deregister(TopologyListener listener) {
    }

    public boolean isZoneLeader() {
        return false;
    }

    public boolean isControllerAvailable() {
        return true;
    }

    public String getZoneLeaderName() {
        return null;
    }

    public Response sendSynchronousToController(ResponseCommand command, long timeout) throws MessageException {
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            byte[] responsePayload = this.controllerChannel.sendSynchronous(payload);
            return (Response)this.serializationService.deserialize(Response.class, responsePayload);
        }
        catch (ChannelException e) {
            throw new MessageException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MessageException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MessageException((Throwable)e);
        }
    }

    public void broadcast(Command command) throws MessageException {
        throw new UnsupportedOperationException();
    }

    public void sendAsynchronous(String runtimeName, Command command) throws MessageException {
        throw new UnsupportedOperationException();
    }

    public Response sendSynchronous(String runtimeName, ResponseCommand command, long timeout) throws MessageException {
        throw new UnsupportedOperationException();
    }

    public List<Response> sendSynchronous(ResponseCommand command, long timeout) throws MessageException {
        throw new UnsupportedOperationException();
    }

    public void sendAsynchronousToController(Command command) throws MessageException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initJndiContexts() {
        InitialContext rootContext;
        this.monitor.connectingToAdminServer();
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", JNDI_FACTORY);
            env.put("java.naming.provider.url", this.adminServerUrl);
            rootContext = new InitialContext(env);
        }
        catch (NamingException e) {
            this.monitor.errorMessage("Error connecting to admin server", e);
            return false;
        }
        Context controllerContext = null;
        Context participantContext = null;
        try {
            controllerContext = JndiHelper.getContext("Fabric3ControllerContext", rootContext);
            try {
                this.controllerChannel = (RuntimeChannel)controllerContext.lookup("Fabric3ControllerChannel");
            }
            catch (NameNotFoundException e) {
                this.monitor.errorMessage("Unable to contact admin server", e);
            }
            participantContext = JndiHelper.getContext("Fabric3Participants", rootContext);
            try {
                participantContext.bind(this.runtimeName, (Object)this.runtimeChannel);
            }
            catch (NameAlreadyBoundException e) {
                participantContext.rebind(this.runtimeName, (Object)this.runtimeChannel);
            }
            boolean e = true;
        }
        catch (NamingException e) {
            boolean bl;
            try {
                this.monitor.errorMessage("Error joining the domain", e);
                bl = false;
            }
            catch (Throwable throwable) {
                JndiHelper.close(rootContext, participantContext, controllerContext);
                throw throwable;
            }
            JndiHelper.close(rootContext, participantContext, controllerContext);
            return bl;
        }
        JndiHelper.close(rootContext, participantContext, controllerContext);
        return e;
    }

    private boolean update() {
        Response response;
        if (!this.synchronize) {
            return true;
        }
        this.monitor.updating();
        RuntimeUpdateCommand command = new RuntimeUpdateCommand(this.runtimeName, this.zoneName, null);
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            byte[] responsePayload = this.controllerChannel.sendSynchronous(payload);
            response = (Response)this.serializationService.deserialize(Response.class, responsePayload);
        }
        catch (RemoteException e) {
            this.monitor.error(e);
            return false;
        }
        catch (ChannelException e) {
            this.monitor.error(e);
            return false;
        }
        catch (IOException e) {
            this.monitor.error(e);
            return false;
        }
        catch (ClassNotFoundException e) {
            this.monitor.error(e);
            return false;
        }
        assert (response instanceof RuntimeUpdateResponse);
        RuntimeUpdateResponse updateResponse = (RuntimeUpdateResponse)response;
        if (!updateResponse.isUpdated()) {
            return false;
        }
        try {
            DeploymentCommand deploymentCommand = updateResponse.getDeploymentCommand();
            this.executorRegistry.execute((Command)deploymentCommand);
        }
        catch (ExecutionException e) {
            this.monitor.error(e);
            return true;
        }
        this.monitor.updated();
        return true;
    }

    private class Work
    implements Runnable {
        private Work() {
        }

        public void run() {
            while (!WebLogicZoneTopologyService.this.initJndiContexts() || !WebLogicZoneTopologyService.this.update()) {
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinDomainListener
    implements Fabric3EventListener<JoinDomain> {
        private JoinDomainListener() {
        }

        public void onEvent(JoinDomain event) {
            boolean result = WebLogicZoneTopologyService.this.initJndiContexts();
            if (!result) {
                WebLogicZoneTopologyService.this.monitor.adminServerUnavailable();
                WebLogicZoneTopologyService.this.executorService.execute(new Work());
                return;
            }
            WebLogicZoneTopologyService.this.update();
        }
    }
}

