/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.security.impl;

import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import org.fabric3.api.SecuritySubject;
import org.fabric3.security.impl.InvalidAuthenticationException;
import org.fabric3.security.impl.SecurityStore;
import org.fabric3.security.impl.SecurityStoreException;
import org.fabric3.spi.security.AuthenticationException;
import org.fabric3.spi.security.AuthenticationService;
import org.fabric3.spi.security.AuthenticationToken;
import org.fabric3.spi.security.BasicSecuritySubject;
import org.fabric3.spi.security.UsernamePasswordToken;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(interfaces={AuthenticationService.class, JMXAuthenticator.class})
@EagerInit
public class AuthenticationServiceImpl
implements AuthenticationService,
JMXAuthenticator {
    private SecurityStore store;

    public AuthenticationServiceImpl(@Reference SecurityStore store) {
        this.store = store;
    }

    public SecuritySubject authenticate(AuthenticationToken<?, ?> token) throws AuthenticationException {
        if (token == null) {
            throw new IllegalArgumentException("Null token");
        }
        if (!(token instanceof UsernamePasswordToken)) {
            throw new UnsupportedOperationException("Token type not supported: " + token.getClass().getName());
        }
        UsernamePasswordToken userToken = (UsernamePasswordToken)token;
        try {
            BasicSecuritySubject subject = this.store.find(userToken.getPrincipal());
            if (subject == null) {
                throw new InvalidAuthenticationException("Invalid authentication information");
            }
            if (!userToken.getCredentials().equals(subject.getPassword())) {
                throw new InvalidAuthenticationException("Invalid authentication information");
            }
            return subject;
        }
        catch (SecurityStoreException e) {
            throw new AuthenticationException((Throwable)((Object)e));
        }
    }

    @Override
    public Subject authenticate(Object credentials) {
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException("Credentials were null");
            }
            throw new SecurityException("Credentials must be a String[]");
        }
        String[] params = (String[])credentials;
        if (params.length != 2) {
            throw new SecurityException("Credentials must consist of a username and password");
        }
        UsernamePasswordToken token = new UsernamePasswordToken(params[0], params[1]);
        try {
            SecuritySubject subject = this.authenticate((AuthenticationToken<?, ?>)token);
            return subject.getJaasSubject();
        }
        catch (AuthenticationException e) {
            throw new SecurityException(e);
        }
    }
}

