/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.format;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.fabric3.spi.binding.format.AbstractParameterEncoder;
import org.fabric3.spi.binding.format.EncoderException;
import org.fabric3.spi.invocation.Message;

public class JAXBParameterEncoder
extends AbstractParameterEncoder {
    private JAXBContext jaxbContext;

    public JAXBParameterEncoder(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public String encodeText(Message message) throws EncoderException {
        return this.serialize(message);
    }

    public Object decode(String operationName, String body) throws EncoderException {
        return this.deserialize(body);
    }

    public Object decodeResponse(String operationName, String serialized) throws EncoderException {
        return this.decode(operationName, serialized);
    }

    public Throwable decodeFault(String operationName, String serialized) throws EncoderException {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(serialized);
            return (Throwable)unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    private String serialize(Message message) throws EncoderException {
        Object body = message.getBody();
        if (body != null && body.getClass().isArray() && !body.getClass().isPrimitive()) {
            Object[] payload = (Object[])body;
            if (payload.length > 1) {
                throw new UnsupportedOperationException("Multiple parameters not supported");
            }
            body = payload[0];
        }
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.marshal(body, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    private Object deserialize(String body) throws EncoderException {
        StringReader reader = new StringReader(body);
        try {
            Unmarshaller marshaller = this.jaxbContext.createUnmarshaller();
            return marshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new EncoderException((Throwable)e);
        }
    }
}

