/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.format;

import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.fabric3.databinding.jaxb.factory.JAXBContextFactory;
import org.fabric3.databinding.jaxb.format.JAXBParameterEncoder;
import org.fabric3.spi.binding.format.EncoderException;
import org.fabric3.spi.binding.format.ParameterEncoder;
import org.fabric3.spi.binding.format.ParameterEncoderFactory;
import org.fabric3.spi.model.physical.ParameterTypeHelper;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class JAXBParameterEncoderFactory
implements ParameterEncoderFactory {
    private JAXBContextFactory factory;

    public JAXBParameterEncoderFactory(@Reference JAXBContextFactory factory) {
        this.factory = factory;
    }

    public ParameterEncoder getInstance(Wire wire, ClassLoader loader) throws EncoderException {
        try {
            HashSet<Class> types = new HashSet<Class>();
            for (InvocationChain chain : wire.getInvocationChains()) {
                PhysicalOperationDefinition definition = chain.getPhysicalOperation();
                List inParams = ParameterTypeHelper.loadSourceInParameterTypes((PhysicalOperationDefinition)definition, (ClassLoader)loader);
                types.addAll(inParams);
                Class outParam = ParameterTypeHelper.loadTargetOutputType((PhysicalOperationDefinition)definition, (ClassLoader)loader);
                types.add(outParam);
                List faults = ParameterTypeHelper.loadSourceFaultTypes((PhysicalOperationDefinition)definition, (ClassLoader)loader);
                types.addAll(faults);
            }
            JAXBContext jaxbContext = this.factory.createJAXBContext(types.toArray(new Class[types.size()]));
            return new JAXBParameterEncoder(jaxbContext);
        }
        catch (JAXBException e) {
            throw new EncoderException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new EncoderException((Throwable)e);
        }
    }
}

