/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.transform;

import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import org.fabric3.databinding.jaxb.factory.JAXBContextFactory;
import org.fabric3.databinding.jaxb.transform.MultiValueArrayTransformer;
import org.fabric3.databinding.jaxb.transform.String2JAXBElementTransformer;
import org.fabric3.databinding.jaxb.transform.String2JAXBObjectTransformer;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerFactory;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2JAXBTransformerFactory
implements TransformerFactory {
    private JAXBContextFactory contextFactory;

    public String2JAXBTransformerFactory(@Reference JAXBContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public boolean canTransform(DataType<?> source, DataType<?> target) {
        return String.class.equals((Object)source.getPhysical()) && target instanceof JavaType;
    }

    public Transformer<?, ?> create(DataType<?> source, DataType<?> target, List<Class<?>> sourceTypes, List<Class<?>> targetTypes) throws TransformationException {
        try {
            HashSet types = new HashSet(sourceTypes);
            types.addAll(targetTypes);
            JAXBContext jaxbContext = this.contextFactory.createJAXBContext(types.toArray(new Class[types.size()]));
            if (sourceTypes.size() == 1) {
                Class<?> type = targetTypes.iterator().next();
                return this.createTransformer(type, jaxbContext);
            }
            if (sourceTypes.size() > 1) {
                Transformer[] transformers = new Transformer[sourceTypes.size()];
                for (int i = 0; i < sourceTypes.size(); ++i) {
                    Class<?> type = sourceTypes.get(i);
                    transformers[i] = this.createTransformer(type, jaxbContext);
                }
                return new MultiValueArrayTransformer(transformers);
            }
            throw new UnsupportedOperationException("Null parameter operations not yet supported");
        }
        catch (JAXBException e) {
            throw new TransformationException((Throwable)e);
        }
    }

    private Transformer<String, Object> createTransformer(Class<?> type, JAXBContext jaxbContext) {
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            return new String2JAXBObjectTransformer(jaxbContext);
        }
        return new String2JAXBElementTransformer(jaxbContext, type);
    }
}

