/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.java.codegen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecureClassLoader;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import org.fabric3.binding.ws.metro.generator.java.codegen.GeneratedInterface;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceGenerationException;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceGenerator;
import org.fabric3.binding.ws.metro.util.ClassDefiner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.osoa.sca.annotations.OneWay;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value=InterfaceGenerator.class)
public class InterfaceGeneratorImpl
implements InterfaceGenerator,
Opcodes {
    private static final String SUFFIX = "F3Subtype";
    private ClassDefiner definer;

    public InterfaceGeneratorImpl(@Reference ClassDefiner definer) {
        this.definer = definer;
    }

    @Override
    public boolean doGeneration(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(WebService.class)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(org.oasisopen.sca.annotation.OneWay.class) && !method.isAnnotationPresent(OneWay.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeneratedInterface generate(Class interfaze, String targetNamespace, String wsdlLocation, String serviceName, String portName) throws InterfaceGenerationException {
        if (!(interfaze.getClassLoader() instanceof SecureClassLoader)) {
            throw new InterfaceGenerationException("Classloader for " + interfaze.getName() + " must be a SecureClassLoader");
        }
        SecureClassLoader loader = (SecureClassLoader)interfaze.getClassLoader();
        String name = interfaze.getName();
        String internalName = name.replace('.', '/');
        String generatedInternalName = internalName + SUFFIX;
        ClassWriter cw = new ClassWriter(0);
        byte[] bytes = this.generate(cw, generatedInternalName, interfaze, targetNamespace, wsdlLocation, serviceName, portName);
        String generatedName = name + SUFFIX;
        try {
            Class<?> clazz = this.definer.defineClass(generatedName, bytes, loader);
            return new GeneratedInterface(clazz, bytes);
        }
        catch (IllegalAccessException e) {
            throw new InterfaceGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new InterfaceGenerationException(e);
        }
    }

    private byte[] generate(ClassWriter cw, String className, Class<?> clazz, String targetNamespace, String wsdlLocation, String serviceName, String portName) {
        Method[] methods;
        String[] interfaces = new String[]{clazz.getName().replace('.', '/')};
        cw.visit(49, 513, className, null, "java/lang/Object", interfaces);
        if (!clazz.isAnnotationPresent(WebService.class)) {
            AnnotationVisitor av = cw.visitAnnotation(this.getSignature(WebService.class), true);
            av.visit("name", (Object)clazz.getSimpleName());
            if (targetNamespace != null) {
                av.visit("targetNamespace", (Object)targetNamespace);
            }
            if (wsdlLocation != null) {
                av.visit("wsdlLocation", (Object)wsdlLocation);
            }
            if (serviceName != null) {
                av.visit("serviceName", (Object)serviceName);
            }
            if (portName != null) {
                av.visit("portName", (Object)portName);
            }
            av.visitEnd();
        }
        for (Method m : methods = clazz.getMethods()) {
            this.generateMethod(cw, m);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateMethod(ClassWriter cw, Method m) {
        String signature = this.getSignature(m);
        MethodVisitor mv = cw.visitMethod(1025, m.getName(), signature, null, null);
        if (!m.isAnnotationPresent(WebMethod.class)) {
            AnnotationVisitor av = mv.visitAnnotation(this.getSignature(WebMethod.class), true);
            av.visitEnd();
        }
        if (!m.isAnnotationPresent(Oneway.class) && (m.isAnnotationPresent(org.oasisopen.sca.annotation.OneWay.class) || m.isAnnotationPresent(OneWay.class))) {
            AnnotationVisitor oneWay = mv.visitAnnotation(this.getSignature(Oneway.class), true);
            oneWay.visitEnd();
        }
        mv.visitEnd();
    }

    private String getSignature(Method m) {
        Class<?>[] parameters;
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> parameter : parameters = m.getParameterTypes()) {
            sb.append(this.getSignature(parameter));
        }
        sb.append(')');
        sb.append(this.getSignature(m.getReturnType()));
        return sb.toString();
    }

    private String getSignature(Class clazz) {
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (!clazz.getName().startsWith("[")) {
            return "L" + clazz.getName().replace('.', '/') + ";";
        }
        return clazz.getName().replace('.', '/');
    }
}

