/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.resolver;

import java.net.MalformedURLException;
import java.net.URL;
import org.fabric3.binding.ws.metro.generator.resolver.TargetUrlResolver;
import org.fabric3.binding.ws.model.WsBindingDefinition;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.spi.federation.DomainTopologyService;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.host.ServletHost;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.policy.EffectivePolicy;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetUrlResolverImpl
implements TargetUrlResolver {
    private DomainTopologyService topologyService;
    private ServletHost servletHost;

    public TargetUrlResolverImpl(@Reference ServletHost servletHost, @Reference(required=false) DomainTopologyService topologyService) {
        this.servletHost = servletHost;
        this.topologyService = topologyService;
    }

    @Override
    public URL resolveUrl(LogicalBinding<WsBindingDefinition> serviceBinding, EffectivePolicy policy) throws GenerationException {
        try {
            URL targetUrl;
            String path = ((WsBindingDefinition)serviceBinding.getDefinition()).getTargetUri().toString();
            if (path == null) {
                path = ((Bindable)serviceBinding.getParent()).getUri().getFragment();
            }
            boolean https = this.requiresHttps(policy);
            if (this.topologyService != null) {
                String zone = ((LogicalComponent)((Bindable)serviceBinding.getParent()).getParent()).getZone();
                if (https) {
                    String base = this.topologyService.getTransportMetaData(zone, "https");
                    targetUrl = new URL("https://" + base + "/" + path);
                } else {
                    String base = this.topologyService.getTransportMetaData(zone, "http");
                    targetUrl = new URL("http://" + base + "/" + path);
                }
            } else {
                targetUrl = https ? new URL("https://localhost:" + this.servletHost.getHttpsPort() + "/" + path) : new URL("http://localhost:" + this.servletHost.getHttpPort() + "/" + path);
            }
            return targetUrl;
        }
        catch (MalformedURLException e) {
            throw new GenerationException((Throwable)e);
        }
    }

    private boolean requiresHttps(EffectivePolicy policy) {
        for (Intent intent : policy.getEndpointIntents()) {
            String localPart = intent.getName().getLocalPart();
            if (!localPart.startsWith("authorization") && !localPart.equals("integrity") && !localPart.startsWith("confidentiality") && !localPart.startsWith("mutualAuthentication") && !localPart.equals("authentication") && !localPart.startsWith("clientAuthentication") && !localPart.startsWith("serverAuthentication")) continue;
            return true;
        }
        return false;
    }
}

