/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.resolver;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.fabric3.binding.ws.metro.generator.resolver.WsdlResolutionException;
import org.fabric3.binding.ws.metro.generator.resolver.WsdlResolver;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.wsdl.contribution.PortSymbol;
import org.fabric3.wsdl.contribution.WsdlSymbol;
import org.fabric3.wsdl.factory.Wsdl4JFactory;
import org.osoa.sca.annotations.Reference;

public class WsdlResolverImpl
implements WsdlResolver {
    private MetaDataStore store;
    private Wsdl4JFactory wsdlFactory;

    public WsdlResolverImpl(@Reference MetaDataStore store, @Reference Wsdl4JFactory wsdlFactory) throws WSDLException {
        this.store = store;
        this.wsdlFactory = wsdlFactory;
    }

    public Definition parseWsdl(URL wsdlLocation) throws WsdlResolutionException {
        try {
            WSDLReader reader = this.wsdlFactory.newReader();
            return reader.readWSDL(wsdlLocation.toURI().toString());
        }
        catch (WSDLException e) {
            throw new WsdlResolutionException(e);
        }
        catch (URISyntaxException e) {
            throw new WsdlResolutionException(e);
        }
    }

    public Definition resolveWsdl(URI contributionUri, QName wsdlName) throws WsdlResolutionException {
        WsdlSymbol symbol = new WsdlSymbol(wsdlName);
        try {
            ResourceElement element = this.store.find(contributionUri, Definition.class, (Symbol)symbol);
            if (element == null) {
                throw new WsdlResolutionException("WSDL not found: " + wsdlName);
            }
            return (Definition)element.getValue();
        }
        catch (StoreException e) {
            throw new WsdlResolutionException(e);
        }
    }

    public Definition resolveWsdlByPortName(URI contributionUri, QName portName) throws WsdlResolutionException {
        ResourceElement resourceElement;
        PortSymbol symbol = new PortSymbol(portName);
        try {
            resourceElement = this.store.find(contributionUri, Port.class, (Symbol)symbol);
        }
        catch (StoreException e) {
            throw new WsdlResolutionException("Error resolving port: " + portName, e);
        }
        if (resourceElement == null) {
            throw new WsdlResolutionException("WSDL port not found: " + portName);
        }
        Resource resource = resourceElement.getResource();
        for (ResourceElement element : resource.getResourceElements()) {
            if (!(element.getSymbol() instanceof WsdlSymbol)) continue;
            return (Definition)element.getValue();
        }
        throw new WsdlResolutionException("WSDL for port not found: " + portName);
    }
}

