/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.wsdl;

import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fabric3.binding.ws.metro.generator.GenerationHelper;
import org.fabric3.binding.ws.metro.generator.MetroGeneratorDelegate;
import org.fabric3.binding.ws.metro.generator.PolicyExpressionMapping;
import org.fabric3.binding.ws.metro.generator.WsdlElement;
import org.fabric3.binding.ws.metro.generator.policy.WsdlPolicyAttacher;
import org.fabric3.binding.ws.metro.generator.resolver.EndpointResolver;
import org.fabric3.binding.ws.metro.generator.resolver.TargetUrlResolver;
import org.fabric3.binding.ws.metro.generator.resolver.WsdlResolver;
import org.fabric3.binding.ws.metro.generator.wsdl.ConcreateWsdlResult;
import org.fabric3.binding.ws.metro.generator.wsdl.WsdlSynthesizer;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroSourceDefinition;
import org.fabric3.binding.ws.metro.provision.MetroTargetDefinition;
import org.fabric3.binding.ws.metro.provision.MetroWsdlSourceDefinition;
import org.fabric3.binding.ws.metro.provision.MetroWsdlTargetDefinition;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.binding.ws.model.WsBindingDefinition;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.policy.EffectivePolicy;
import org.fabric3.wsdl.factory.Wsdl4JFactory;
import org.fabric3.wsdl.model.WsdlServiceContract;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlGeneratorDelegate
implements MetroGeneratorDelegate<WsdlServiceContract> {
    private static final String REPLACEABLE_ADDRESS = "REPLACE_WITH_ACTUAL_URL";
    private WsdlResolver wsdlResolver;
    private EndpointResolver endpointResolver;
    private WsdlSynthesizer wsdlSynthesizer;
    private WsdlPolicyAttacher policyAttacher;
    private Wsdl4JFactory wsdlFactory;
    private TargetUrlResolver targetUrlResolver;
    private TransformerFactory transformerFactory;

    public WsdlGeneratorDelegate(@Reference WsdlResolver wsdlResolver, @Reference EndpointResolver endpointResolver, @Reference WsdlSynthesizer wsdlSynthesizer, @Reference WsdlPolicyAttacher policyAttacher, @Reference Wsdl4JFactory wsdlFactory, @Reference TargetUrlResolver targetUrlResolver) throws WSDLException {
        this.wsdlResolver = wsdlResolver;
        this.endpointResolver = endpointResolver;
        this.wsdlSynthesizer = wsdlSynthesizer;
        this.policyAttacher = policyAttacher;
        this.wsdlFactory = wsdlFactory;
        this.targetUrlResolver = targetUrlResolver;
        this.transformerFactory = TransformerFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetroSourceDefinition generateSource(LogicalBinding<WsBindingDefinition> binding, WsdlServiceContract contract, EffectivePolicy policy) throws GenerationException {
        String serializedWsdl;
        ServiceEndpointDefinition endpointDefinition;
        WsdlElement wsdlElement;
        String wsdlElementString;
        Definition wsdl;
        URI targetUri = ((WsBindingDefinition)binding.getDefinition()).getTargetUri();
        URL wsdlLocation = this.getWsdlLocation(binding);
        if (wsdlLocation != null) {
            wsdl = this.wsdlResolver.parseWsdl(wsdlLocation);
        } else {
            URI contributionUri = ((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
            QName wsdlName = contract.getWsdlQName();
            wsdl = this.wsdlResolver.resolveWsdl(contributionUri, wsdlName);
        }
        if (targetUri != null) {
            wsdlElementString = ((WsBindingDefinition)binding.getDefinition()).getWsdlElement();
            if (wsdlElementString != null) {
                wsdlElement = GenerationHelper.parseWsdlElement(wsdlElementString);
                endpointDefinition = this.endpointResolver.resolveServiceEndpoint(wsdlElement, wsdl, targetUri);
            } else {
                ConcreateWsdlResult result = this.wsdlSynthesizer.synthesize(binding, REPLACEABLE_ADDRESS, contract, policy, wsdl, targetUri);
                wsdl = result.getDefiniton();
                endpointDefinition = new ServiceEndpointDefinition(result.getServiceName(), result.getPortName(), targetUri);
            }
        } else {
            wsdlElementString = ((WsBindingDefinition)binding.getDefinition()).getWsdlElement();
            if (wsdlElementString == null) {
                Bindable service = (Bindable)binding.getParent();
                targetUri = URI.create(service.getUri().getFragment());
                ConcreateWsdlResult result = this.wsdlSynthesizer.synthesize(binding, REPLACEABLE_ADDRESS, contract, policy, wsdl, targetUri);
                wsdl = result.getDefiniton();
                QName serviceName = result.getServiceName();
                endpointDefinition = new ServiceEndpointDefinition(serviceName, result.getPortName(), targetUri);
            } else {
                wsdlElement = GenerationHelper.parseWsdlElement(wsdlElementString);
                endpointDefinition = this.endpointResolver.resolveServiceEndpoint(wsdlElement, wsdl, targetUri);
            }
        }
        ArrayList<QName> intentNames = new ArrayList<QName>();
        Set endpointIntents = policy.getEndpointIntents();
        for (Intent intent : endpointIntents) {
            intentNames.add(intent.getName());
        }
        ArrayList<Element> policyExpressions = new ArrayList<Element>();
        for (PolicySet policySet : policy.getEndpointPolicySets()) {
            policyExpressions.add(policySet.getExpression());
        }
        List<PolicyExpressionMapping> mappings = GenerationHelper.createMappings(policy);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            serializedWsdl = !policyExpressions.isEmpty() || !mappings.isEmpty() ? this.mergePolicy(wsdl, policyExpressions, mappings) : this.serializeToString(wsdl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return new MetroWsdlSourceDefinition(endpointDefinition, serializedWsdl, intentNames);
    }

    @Override
    public MetroTargetDefinition generateTarget(LogicalBinding<WsBindingDefinition> binding, WsdlServiceContract contract, EffectivePolicy policy) throws GenerationException {
        URL targetUrl = null;
        URI targetUri = ((WsBindingDefinition)binding.getDefinition()).getTargetUri();
        if (targetUri != null) {
            try {
                targetUrl = targetUri.toURL();
            }
            catch (MalformedURLException e) {
                throw new GenerationException((Throwable)e);
            }
        }
        return this.generateTarget(binding, targetUrl, contract, policy);
    }

    @Override
    public MetroTargetDefinition generateServiceBindingTarget(LogicalBinding<WsBindingDefinition> serviceBinding, WsdlServiceContract contract, EffectivePolicy policy) throws GenerationException {
        URL targetUrl = this.targetUrlResolver.resolveUrl(serviceBinding, policy);
        return this.generateTarget(serviceBinding, targetUrl, contract, policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetroTargetDefinition generateTarget(LogicalBinding<WsBindingDefinition> binding, URL targetUrl, WsdlServiceContract contract, EffectivePolicy policy) throws GenerationException {
        String serializedWsdl;
        ReferenceEndpointDefinition endpointDefinition;
        WsdlElement wsdlElement;
        String wsdlElementString;
        Definition wsdl;
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        URL wsdlLocation = this.getWsdlLocation(binding);
        if (wsdlLocation != null) {
            wsdl = this.wsdlResolver.parseWsdl(wsdlLocation);
        } else {
            URI contributionUri = ((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
            QName wsdlName = contract.getWsdlQName();
            wsdl = this.wsdlResolver.resolveWsdl(contributionUri, wsdlName);
        }
        if (targetUrl != null) {
            wsdlElementString = ((WsBindingDefinition)binding.getDefinition()).getWsdlElement();
            if (wsdlElementString != null) {
                wsdlElement = GenerationHelper.parseWsdlElement(wsdlElementString);
                endpointDefinition = this.endpointResolver.resolveReferenceEndpoint(wsdlElement, wsdl);
            } else {
                String endpointAddress = targetUrl.toString();
                URI targetUri = ((WsBindingDefinition)binding.getDefinition()).getTargetUri();
                ConcreateWsdlResult result = this.wsdlSynthesizer.synthesize(binding, endpointAddress, contract, policy, wsdl, targetUri);
                wsdl = result.getDefiniton();
                QName portTypeName = contract.getPortType().getQName();
                QName portName = result.getPortName();
                endpointDefinition = new ReferenceEndpointDefinition(result.getServiceName(), false, portName, portTypeName, targetUrl);
            }
        } else {
            wsdlElementString = ((WsBindingDefinition)binding.getDefinition()).getWsdlElement();
            if (wsdlElementString == null) {
                URI bindableUri = ((Bindable)binding.getParent()).getUri();
                throw new GenerationException("Either a uri or wsdlElement must be specified for the web service binding on " + bindableUri);
            }
            wsdlElement = GenerationHelper.parseWsdlElement(wsdlElementString);
            endpointDefinition = this.endpointResolver.resolveReferenceEndpoint(wsdlElement, wsdl);
        }
        Set endpointIntents = policy.getEndpointIntents();
        ArrayList<QName> intentNames = new ArrayList<QName>();
        for (Intent intent : endpointIntents) {
            intentNames.add(intent.getName());
        }
        ArrayList<Element> policyExpressions = new ArrayList<Element>();
        for (PolicySet policySet : policy.getEndpointPolicySets()) {
            policyExpressions.add(policySet.getExpression());
        }
        List<PolicyExpressionMapping> mappings = GenerationHelper.createMappings(policy);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            serializedWsdl = !policyExpressions.isEmpty() || !mappings.isEmpty() ? this.mergePolicy(wsdl, policyExpressions, mappings) : this.serializeToString(wsdl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        SecurityConfiguration securityConfiguration = GenerationHelper.createSecurityConfiguration(definition);
        ConnectionConfiguration connectionConfiguration = GenerationHelper.createConnectionConfiguration(definition);
        return new MetroWsdlTargetDefinition(endpointDefinition, serializedWsdl, intentNames, securityConfiguration, connectionConfiguration);
    }

    private URL getWsdlLocation(LogicalBinding<WsBindingDefinition> binding) throws GenerationException {
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        try {
            String location = definition.getWsdlLocation();
            if (location != null) {
                return new URL(location);
            }
        }
        catch (MalformedURLException e) {
            throw new GenerationException((Throwable)e);
        }
        return null;
    }

    private String serializeToString(Definition wsdl) throws GenerationException {
        try {
            WSDLWriter writer = this.wsdlFactory.newWriter();
            StringWriter stringWriter = new StringWriter();
            writer.writeWSDL(wsdl, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (WSDLException e) {
            throw new GenerationException((Throwable)e);
        }
    }

    private String mergePolicy(Definition wsdl, List<Element> policyExpressions, List<PolicyExpressionMapping> mappings) throws GenerationException {
        try {
            Document wsdlDocument = this.wsdlFactory.newWriter().getDocument(wsdl);
            this.policyAttacher.attach(wsdlDocument, policyExpressions, mappings);
            DOMSource source = new DOMSource(wsdlDocument);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new GenerationException((Throwable)e);
        }
        catch (WSDLException e) {
            throw new GenerationException((Throwable)e);
        }
    }
}

