/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.wsdl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.fabric3.binding.ws.metro.generator.wsdl.ConcreateWsdlResult;
import org.fabric3.binding.ws.metro.generator.wsdl.WsdlSynthesisException;
import org.fabric3.binding.ws.metro.generator.wsdl.WsdlSynthesizer;
import org.fabric3.binding.ws.model.WsBindingDefinition;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.spi.classloader.ClassLoaderObjectInputStream;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.policy.EffectivePolicy;
import org.fabric3.wsdl.model.WsdlServiceContract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlSynthesizerImpl
implements WsdlSynthesizer {
    private static final QName SOAP_BINDING = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
    private static final QName SOAP_ADDRESS = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static final QName SOAP_BODY = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body");
    private static final QName SOAP_OPERATION = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "operation");
    public static final String HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";

    @Override
    public ConcreateWsdlResult synthesize(LogicalBinding<WsBindingDefinition> logicalBinding, String endpointAddress, WsdlServiceContract contract, EffectivePolicy policy, Definition wsdl, URI targetUri) throws WsdlSynthesisException {
        Definition copy = this.clone(wsdl);
        String targetNamespace = wsdl.getTargetNamespace();
        String localName = ((Bindable)logicalBinding.getParent()).getUri().getFragment();
        QName serviceName = new QName(targetNamespace, localName);
        String localPortName = localName + "Port";
        Binding binding = copy.createBinding();
        binding.setPortType(copy.getPortType(contract.getPortType().getQName()));
        binding.setQName(new QName(targetNamespace, localName + "Binding"));
        try {
            SOAPBinding soapBinding = (SOAPBinding)copy.getExtensionRegistry().createExtension(Binding.class, SOAP_BINDING);
            soapBinding.setStyle("document");
            soapBinding.setTransportURI(HTTP_TRANSPORT);
            binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
            for (Operation operation : contract.getOperations()) {
                BindingOperation bindingOperation = copy.createBindingOperation();
                bindingOperation.setName(operation.getName());
                SOAPOperation soapOperation = (SOAPOperation)copy.getExtensionRegistry().createExtension(BindingOperation.class, SOAP_OPERATION);
                soapOperation.setSoapActionURI("");
                bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
                BindingInput input = copy.createBindingInput();
                SOAPBody soapBody = (SOAPBody)copy.getExtensionRegistry().createExtension(BindingInput.class, SOAP_BODY);
                soapBody.setUse("literal");
                input.addExtensibilityElement((ExtensibilityElement)soapBody);
                bindingOperation.setBindingInput(input);
                BindingOutput output = copy.createBindingOutput();
                SOAPBody outSoapBody = (SOAPBody)copy.getExtensionRegistry().createExtension(BindingInput.class, SOAP_BODY);
                outSoapBody.setUse("literal");
                output.addExtensibilityElement((ExtensibilityElement)outSoapBody);
                bindingOperation.setBindingOutput(output);
                binding.addBindingOperation(bindingOperation);
                binding.setUndefined(false);
            }
            copy.addBinding(binding);
            QName portName = new QName(targetNamespace, localPortName);
            Port port = copy.createPort();
            port.setName(localPortName);
            port.setBinding(binding);
            SOAPAddress soapAddress = (SOAPAddress)copy.getExtensionRegistry().createExtension(Port.class, SOAP_ADDRESS);
            soapAddress.setLocationURI(endpointAddress);
            port.addExtensibilityElement((ExtensibilityElement)soapAddress);
            Service service = copy.createService();
            service.setQName(serviceName);
            service.addPort(port);
            copy.addService(service);
            return new ConcreateWsdlResult(copy, serviceName, portName);
        }
        catch (WSDLException e) {
            throw new WsdlSynthesisException(e);
        }
    }

    private Definition clone(Definition wsdl) throws WsdlSynthesisException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(wsdl);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ClassLoaderObjectInputStream is = new ClassLoaderObjectInputStream((InputStream)bis, Definition.class.getClassLoader());
            Definition copy = (Definition)is.readObject();
            copy.getServices().clear();
            copy.getBindings().clear();
            return copy;
        }
        catch (IOException e) {
            throw new WsdlSynthesisException(e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }
}

