/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.wire.Interceptor;

public abstract class AbstractMetroTargetInterceptor
implements Interceptor {
    protected static final Message NULL_RESPONSE = new MessageImpl();
    private SecurityConfiguration securityConfiguration;
    private ConnectionConfiguration connectionConfiguration;

    public AbstractMetroTargetInterceptor(SecurityConfiguration securityConfiguration, ConnectionConfiguration connectionConfiguration) {
        this.securityConfiguration = securityConfiguration;
        this.connectionConfiguration = connectionConfiguration;
    }

    public Interceptor getNext() {
        return null;
    }

    public void setNext(Interceptor next) {
        throw new IllegalStateException("This interceptor must be the last in the chain");
    }

    protected void configureSecurity(BindingProvider provider) {
        if (this.securityConfiguration == null) {
            return;
        }
        Map context = provider.getRequestContext();
        if (this.securityConfiguration.getUsername() != null) {
            context.put("f3.username", this.securityConfiguration.getUsername());
            context.put("f3.password", this.securityConfiguration.getPassword());
        } else if (this.securityConfiguration.getAlias() != null) {
            context.put("f3.keystore.alias", this.securityConfiguration.getAlias());
        }
    }

    protected void configureConnection(BindingProvider provider) {
        if (this.connectionConfiguration == null) {
            return;
        }
        Map context = provider.getRequestContext();
        if (this.connectionConfiguration.getConnectTimeout() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.connect.timeout", this.connectionConfiguration.getConnectTimeout());
        }
        if (this.connectionConfiguration.getRequestTimeout() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.request.timeout", this.connectionConfiguration.getRequestTimeout());
        }
        if (this.connectionConfiguration.getClientStreamingChunkSize() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", this.connectionConfiguration.getClientStreamingChunkSize());
        }
    }
}

