/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.wsdl.parser.InaccessibleWSDLException;
import com.sun.xml.wss.SecurityEnvironment;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.runtime.core.WsitClientConfigurationContainer;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetroDispatchObjectFactory
implements ObjectFactory<Dispatch<Source>> {
    private QName serviceName;
    private QName portName;
    private WebServiceFeature[] features;
    private File wsitConfiguration;
    private ExecutorService executorService;
    private SecurityEnvironment securityEnvironment;
    private Dispatch<Source> dispatch;
    private URL wsdlLocation;

    public MetroDispatchObjectFactory(ReferenceEndpointDefinition endpointDefinition, URL wsdlLocation, File wsitConfiguration, WebServiceFeature[] features, ExecutorService executorService, SecurityEnvironment securityEnvironment) {
        this.wsdlLocation = wsdlLocation;
        this.serviceName = endpointDefinition.getServiceName();
        this.portName = endpointDefinition.getPortName();
        this.features = features;
        this.wsitConfiguration = wsitConfiguration;
        this.executorService = executorService;
        this.securityEnvironment = securityEnvironment;
    }

    public Dispatch<Source> getInstance() throws ObjectCreationException {
        if (this.dispatch == null) {
            this.dispatch = this.createProxy();
        }
        return this.dispatch;
    }

    private Dispatch<Source> createProxy() throws ObjectCreationException {
        try {
            WSService.InitParams params = new WSService.InitParams();
            WsitClientConfigurationContainer container = this.wsitConfiguration != null ? new WsitClientConfigurationContainer(this.wsitConfiguration.toURI().toURL(), this.securityEnvironment) : new WsitClientConfigurationContainer(this.securityEnvironment);
            params.setContainer((Container)container);
            Service service = WSService.create((URL)this.wsdlLocation, (QName)this.serviceName, (WSService.InitParams)params);
            service.setExecutor((Executor)this.executorService);
            return service.createDispatch(this.portName, Source.class, Service.Mode.PAYLOAD, this.features);
        }
        catch (InaccessibleWSDLException e) {
            throw new ObjectCreationException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }
}

