/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import com.sun.xml.ws.wsdl.parser.InaccessibleWSDLException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.ws.BindingProvider;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.AbstractMetroTargetInterceptor;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.oasisopen.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetroJavaTargetInterceptor
extends AbstractMetroTargetInterceptor {
    private ObjectFactory<?> proxyFactory;
    private Method method;
    private boolean oneWay;

    public MetroJavaTargetInterceptor(ObjectFactory<?> proxyFactory, Method method, boolean oneWay, SecurityConfiguration securityConfiguration, ConnectionConfiguration connectionConfiguration) {
        super(securityConfiguration, connectionConfiguration);
        this.proxyFactory = proxyFactory;
        this.method = method;
        this.oneWay = oneWay;
    }

    public Message invoke(Message msg) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Object[] payload = (Object[])msg.getBody();
            Object proxy = this.proxyFactory.getInstance();
            BindingProvider provider = (BindingProvider)proxy;
            this.configureSecurity(provider);
            this.configureConnection(provider);
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (this.oneWay) {
                this.method.invoke(proxy, payload);
                Message message = NULL_RESPONSE;
                return message;
            }
            Object ret = this.method.invoke(proxy, payload);
            MessageImpl messageImpl = new MessageImpl(ret, false, null);
            return messageImpl;
        }
        catch (InaccessibleWSDLException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            MessageImpl messageImpl = new MessageImpl((Object)e.getTargetException(), true, null);
            return messageImpl;
        }
        catch (ObjectCreationException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

