/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.security;

import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.Timestamp;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.saml.Assertion;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.SecuritySubject;
import org.fabric3.binding.ws.metro.runtime.security.CertificateValidator;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.security.AuthenticationException;
import org.fabric3.spi.security.AuthenticationService;
import org.fabric3.spi.security.AuthenticationToken;
import org.fabric3.spi.security.KeyStoreManager;
import org.fabric3.spi.security.UsernamePasswordToken;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class F3SecurityEnvironment
implements SecurityEnvironment {
    private static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private AuthenticationService authenticationService;
    private KeyStoreManager keyStoreManager;
    private CertificateValidator certificateValidator;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private char[] keyStorePassword;
    private final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");

    public F3SecurityEnvironment(@Reference AuthenticationService authenticationService, @Reference CertificateValidator certificateValidator, @Reference KeyStoreManager keyStoreManager) {
        this.authenticationService = authenticationService;
        this.certificateValidator = certificateValidator;
        this.keyStoreManager = keyStoreManager;
    }

    @Init
    public void init() throws XWSSecurityException {
        this.keyStore = this.keyStoreManager.getKeyStore();
        String password = this.keyStoreManager.getKeyStorePassword();
        if (password != null) {
            this.keyStorePassword = password.toCharArray();
        }
        this.trustStore = this.keyStoreManager.getTrustStore();
    }

    public X509Certificate getDefaultCertificate(Map context) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        return this.getDefaultCertificateInternal(this.trustStore, context);
    }

    public X509Certificate getCertificate(Map context, String alias, boolean forSigning) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        try {
            if (forSigning) {
                if (alias == null || "".equals(alias) && forSigning) {
                    return this.getDefaultCertificate(context);
                }
                return (X509Certificate)this.keyStore.getCertificate(alias);
            }
            if ("".equals(alias) || alias == null) {
                return this.getDefaultCertificateInternal(this.trustStore, context);
            }
            return (X509Certificate)this.trustStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
    }

    public SecretKey getSecretKey(Map context, String alias, boolean encryptMode) throws XWSSecurityException {
        this.checkEnabled();
        throw new UnsupportedOperationException();
    }

    public PrivateKey getPrivateKey(Map context, String alias) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        try {
            return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword);
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
    }

    public PublicKey getPublicKey(Map context, byte[] identifier) throws XWSSecurityRuntimeException, XWSSecurityException {
        this.checkEnabled();
        return this.getCertificate(context, identifier).getPublicKey();
    }

    public PublicKey getPublicKey(Map context, byte[] identifier, String valueType) throws XWSSecurityRuntimeException, XWSSecurityException {
        this.checkEnabled();
        if ("Identifier".equals(valueType)) {
            return this.getCertificate(context, identifier).getPublicKey();
        }
        throw new UnsupportedOperationException();
    }

    public X509Certificate getCertificate(Map context, byte[] identifier) throws XWSSecurityRuntimeException, XWSSecurityException {
        this.checkEnabled();
        try {
            if (this.trustStore != null) {
                Enumeration<String> aliases = this.trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509Cert;
                    byte[] keyId;
                    String alias = aliases.nextElement();
                    Certificate cert = this.trustStore.getCertificate(alias);
                    if (cert == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier((X509Certificate)(x509Cert = (X509Certificate)cert))) == null || !Arrays.equals(identifier, keyId)) continue;
                    return x509Cert;
                }
            }
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        throw new XWSSecurityRuntimeException("Certificate not found");
    }

    public X509Certificate getCertificate(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        this.checkEnabled();
        if ("Identifier".equals(valueType)) {
            return this.getCertificate(context, identifier);
        }
        throw new UnsupportedOperationException();
    }

    public PrivateKey getPrivateKey(Map context, X509Certificate certificate) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !cert.equals(certificate)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword);
            }
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        throw new XWSSecurityRuntimeException("Private key not found");
    }

    public PrivateKey getPrivateKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword);
            }
        }
        catch (Exception e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        throw new XWSSecurityRuntimeException("Private key not found for serial number: " + serialNumber);
    }

    public X509Certificate getCertificate(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        try {
            Enumeration<String> aliases = this.trustStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                String alias = aliases.nextElement();
                Certificate cert = this.trustStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || !(x509Cert = (X509Certificate)cert).getPublicKey().equals(publicKey)) continue;
                return x509Cert;
            }
        }
        catch (Exception e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        throw new XWSSecurityRuntimeException("Certificate not found");
    }

    public PrivateKey getPrivateKey(Map context, byte[] identifier) throws XWSSecurityRuntimeException, XWSSecurityException {
        this.checkEnabled();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || (cert = this.keyStore.getCertificate(alias)) == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier((X509Certificate)(x509Cert = (X509Certificate)cert))) == null || !Arrays.equals(identifier, keyId)) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        throw new XWSSecurityRuntimeException("Private key not found");
    }

    public PrivateKey getPrivateKey(Map context, byte[] identifier, String type) throws XWSSecurityException {
        this.checkEnabled();
        if ("Identifier".equals(type)) {
            return this.getPrivateKey(context, identifier);
        }
        throw new UnsupportedOperationException();
    }

    public PrivateKey getPrivateKey(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        if (forSign) {
            throw new UnsupportedOperationException();
        }
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || !publicKey.equals((cert = this.keyStore.getCertificate(alias)).getPublicKey())) continue;
                return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword);
            }
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        throw new XWSSecurityRuntimeException("Private key not found");
    }

    public PublicKey getPublicKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        return this.getCertificate(context, serialNumber, issuerName).getPublicKey();
    }

    public X509Certificate getCertificate(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        try {
            if (this.trustStore != null) {
                Enumeration<String> aliases = this.trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate cert = this.trustStore.getCertificate(alias);
                    if (cert == null || !"X.509".equals(cert.getType())) continue;
                    X509Certificate x509Cert = (X509Certificate)cert;
                    String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                    BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                    if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                    return x509Cert;
                }
            }
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        throw new XWSSecurityRuntimeException("Certificate key not found");
    }

    public boolean authenticateUser(Map context, String username, String password) throws XWSSecurityRuntimeException {
        WorkContext workContext = (WorkContext)context.get("f3.work.context");
        if (workContext == null) {
            throw new AssertionError((Object)"Work context not set");
        }
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        try {
            SecuritySubject subject = this.authenticationService.authenticate((AuthenticationToken)token);
            workContext.setSubject(subject);
            return true;
        }
        catch (AuthenticationException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
    }

    public boolean authenticateUser(Map context, String username, String digest, String nonce, String created) throws XWSSecurityException {
        throw new UnsupportedOperationException("Digest authentication not supported");
    }

    public String getUsername(Map context) {
        return (String)context.get("f3.username");
    }

    public String getPassword(Map context) {
        return (String)context.get("f3.password");
    }

    public String authenticateUser(Map context, String username) {
        throw new UnsupportedOperationException("Username + context authentication not supported");
    }

    public Subject getSubject() {
        throw new UnsupportedOperationException();
    }

    public void validateTimestamp(Map context, Timestamp timestamp, long maxClockSkew, long freshnessLimit) {
        this.checkEnabled();
        this.validateTimestamp(context, timestamp.getCreated(), timestamp.getExpires(), maxClockSkew, freshnessLimit);
    }

    public void validateTimestamp(Map context, String created, String expires, long maxClockSkew, long freshnessLimit) {
        this.checkEnabled();
        if (this.expiresBeforeCreated(created, expires)) {
            XWSSecurityRuntimeException e = new XWSSecurityRuntimeException("Message expired!");
            QName name = new QName(WSU_NS, "MessageExpired", "wsu");
            WssSoapFaultException sfe = new WssSoapFaultException(name, "Message expired", null, null);
            sfe.initCause((Throwable)e);
            throw sfe;
        }
        this.validateCreationTime(context, created, maxClockSkew, freshnessLimit);
    }

    public void validateCreationTime(Map context, String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityRuntimeException {
        Date created;
        this.checkEnabled();
        SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
        try {
            created = calendarFormatter1.parse(creationTime);
        }
        catch (ParseException pe) {
            try {
                created = calendarFormatter2.parse(creationTime);
            }
            catch (ParseException e) {
                throw new XWSSecurityRuntimeException((Throwable)e);
            }
        }
        Date current = this.getFreshnessAndSkewAdjustedDate(maxClockSkew, timestampFreshnessLimit);
        if (created.before(current)) {
            throw new XWSSecurityRuntimeException("The creation time is older than the current time");
        }
        Date currentTime = this.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, true);
        if (currentTime.before(created)) {
            throw new XWSSecurityRuntimeException("The creation time is ahead of the current time.");
        }
    }

    public boolean validateCertificate(X509Certificate certificate, Map context) throws XWSSecurityRuntimeException {
        this.checkEnabled();
        return this.certificateValidator.validate(certificate, this.keyStore);
    }

    public CallbackHandler getCallbackHandler() {
        return null;
    }

    public void updateOtherPartySubject(Subject subject, String username, String password) {
    }

    public void updateOtherPartySubject(Subject subject, X509Certificate certificate) {
    }

    public void updateOtherPartySubject(Subject subject, Assertion assertion) {
    }

    public void updateOtherPartySubject(Subject subject, XMLStreamReader reader) {
    }

    public void updateOtherPartySubject(Subject subject, Subject bootstrap) {
    }

    public void validateSAMLAssertion(Map context, Element assertion) {
        throw new UnsupportedOperationException();
    }

    public void validateSAMLAssertion(Map context, XMLStreamReader reader) {
        throw new UnsupportedOperationException();
    }

    public Element locateSAMLAssertion(Map context, Element binding, String assertionId, Document ownerDoc) {
        throw new UnsupportedOperationException();
    }

    public AuthenticationTokenPolicy.SAMLAssertionBinding populateSAMLPolicy(Map fpcontext, AuthenticationTokenPolicy.SAMLAssertionBinding policy, DynamicApplicationContext context) {
        throw new UnsupportedOperationException();
    }

    public boolean validateAndCacheNonce(Map map, String s, String s1, long l) throws XWSSecurityException {
        throw new UnsupportedOperationException();
    }

    public boolean isSelfCertificate(X509Certificate cert) {
        return false;
    }

    public KerberosContext doKerberosLogin() throws XWSSecurityException {
        throw new UnsupportedOperationException();
    }

    public KerberosContext doKerberosLogin(byte[] tokenValue) throws XWSSecurityException {
        throw new UnsupportedOperationException();
    }

    public void updateOtherPartySubject(Subject subject, GSSName clientCred, GSSCredential gssCred) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expiresBeforeCreated(String creationTime, String expirationTime) throws XWSSecurityRuntimeException {
        Date created;
        Date expires = null;
        try {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
            synchronized (simpleDateFormat) {
                created = this.calendarFormatter1.parse(creationTime);
                if (expirationTime != null) {
                    expires = this.calendarFormatter1.parse(expirationTime);
                }
            }
        }
        catch (ParseException pe) {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
            synchronized (simpleDateFormat) {
                try {
                    created = this.calendarFormatter2.parse(creationTime);
                    if (expirationTime != null) {
                        expires = this.calendarFormatter2.parse(expirationTime);
                    }
                }
                catch (ParseException xpe) {
                    throw new XWSSecurityRuntimeException(xpe.getMessage());
                }
            }
        }
        return expires != null && expires.equals(created) || expires != null && expires.before(created);
    }

    private Date getGMTDateWithSkewAdjusted(Calendar c, long maxClockSkew, boolean addSkew) {
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    private Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) {
        GregorianCalendar c = new GregorianCalendar();
        long offset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    private X509Certificate getDefaultCertificateInternal(KeyStore store, Map context) throws XWSSecurityRuntimeException {
        try {
            String alias = (String)context.get("f3.keystore.alias");
            if (alias != null) {
                Certificate certificate = store.getCertificate(alias);
                if (certificate == null) {
                    throw new XWSSecurityRuntimeException("Certificate not found for alias in keystore: " + alias);
                }
                if (!(certificate instanceof X509Certificate)) {
                    throw new XWSSecurityRuntimeException("Not an X.509 certificate: " + alias);
                }
                return (X509Certificate)certificate;
            }
            Object obj = context.get("certificate");
            if (obj instanceof X509Certificate) {
                return (X509Certificate)obj;
            }
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                Certificate thisCertificate;
                String currentAlias = aliases.nextElement();
                if (!store.isKeyEntry(currentAlias) || (thisCertificate = store.getCertificate(currentAlias)) == null || !(thisCertificate instanceof X509Certificate)) continue;
                if (alias == null) {
                    alias = currentAlias;
                    continue;
                }
                alias = null;
                break;
            }
            if (alias == null) {
                throw new XWSSecurityRuntimeException("Unable to determine alias for default certificate in keystore");
            }
            return (X509Certificate)store.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
    }

    private void checkEnabled() throws XWSSecurityRuntimeException {
        if (this.keyStore == null) {
            throw new XWSSecurityRuntimeException("Keystore not configured");
        }
        if (this.trustStore == null) {
            throw new XWSSecurityRuntimeException("Truststore not configured");
        }
    }
}

