/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import java.net.URI;
import org.fabric3.binding.ws.metro.provision.MetroSourceDefinition;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.binding.ws.metro.runtime.core.EndpointException;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.SourceWireAttacher;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetroSourceWireAttacher<T extends MetroSourceDefinition>
implements SourceWireAttacher<T> {
    protected EndpointService endpointService;

    public AbstractMetroSourceWireAttacher(EndpointService endpointService) {
        this.endpointService = endpointService;
    }

    public void detach(T source, PhysicalTargetDefinition target) throws WiringException {
        try {
            ServiceEndpointDefinition endpointDefinition = ((MetroSourceDefinition)((Object)source)).getEndpointDefinition();
            URI servicePath = endpointDefinition.getServicePath();
            String path = servicePath.toString();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.endpointService.unregisterService(path);
        }
        catch (EndpointException e) {
            throw new WiringException((Throwable)((Object)e));
        }
    }

    public void detachObjectFactory(T source, PhysicalTargetDefinition target) {
    }

    public void attachObjectFactory(T source, ObjectFactory<?> objectFactory, PhysicalTargetDefinition target) {
        throw new UnsupportedOperationException();
    }
}

