/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import com.sun.xml.ws.api.BindingID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import org.fabric3.binding.ws.metro.provision.MetroJavaSourceDefinition;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.binding.ws.metro.runtime.core.EndpointConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.EndpointException;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.JaxbInvoker;
import org.fabric3.binding.ws.metro.runtime.policy.FeatureResolver;
import org.fabric3.binding.ws.metro.runtime.wire.AbstractMetroSourceWireAttacher;
import org.fabric3.binding.ws.metro.runtime.wire.WireAttacherHelper;
import org.fabric3.binding.ws.metro.util.BindingIdResolver;
import org.fabric3.spi.artifact.ArtifactCache;
import org.fabric3.spi.artifact.CacheException;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetroJavaSourceWireAttacher
extends AbstractMetroSourceWireAttacher<MetroJavaSourceDefinition> {
    private ClassLoaderRegistry classLoaderRegistry;
    private FeatureResolver featureResolver;
    private BindingIdResolver bindingIdResolver;
    private WireAttacherHelper wireAttacherHelper;
    private ArtifactCache artifactCache;

    public MetroJavaSourceWireAttacher(@Reference ClassLoaderRegistry classLoaderRegistry, @Reference FeatureResolver featureResolver, @Reference BindingIdResolver bindingIdResolver, @Reference WireAttacherHelper wireAttacherHelper, @Reference ArtifactCache artifactCache, @Reference EndpointService endpointService) {
        super(endpointService);
        this.classLoaderRegistry = classLoaderRegistry;
        this.featureResolver = featureResolver;
        this.bindingIdResolver = bindingIdResolver;
        this.wireAttacherHelper = wireAttacherHelper;
        this.artifactCache = artifactCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(MetroJavaSourceDefinition source, PhysicalTargetDefinition target, Wire wire) throws WiringException {
        try {
            ServiceEndpointDefinition endpointDefinition = source.getEndpointDefinition();
            QName serviceName = endpointDefinition.getServiceName();
            QName portName = endpointDefinition.getPortName();
            URI servicePath = endpointDefinition.getServicePath();
            List invocationChains = wire.getInvocationChains();
            URI classLoaderId = source.getSEIClassLoaderUri();
            URL wsdlLocation = source.getWsdlLocation();
            List<QName> requestedIntents = source.getIntents();
            ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(classLoaderId);
            String interfaze = source.getInterface();
            byte[] bytes = source.getGeneratedInterface();
            if (!(classLoader instanceof SecureClassLoader)) {
                throw new WiringException("Classloader for " + interfaze + " must be a SecureClassLoader");
            }
            Class<?> seiClass = this.wireAttacherHelper.loadSEI(interfaze, bytes, (SecureClassLoader)classLoader);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                String path;
                Thread.currentThread().setContextClassLoader(classLoader);
                BindingID bindingId = this.bindingIdResolver.resolveBindingId(requestedIntents);
                WebServiceFeature[] features = this.featureResolver.getFeatures(requestedIntents);
                URL generatedWsdl = null;
                List<URL> generatedSchemas = null;
                String wsdl = source.getWsdl();
                if (wsdl != null) {
                    generatedWsdl = wsdlLocation = this.artifactCache.cache(servicePath, (InputStream)new ByteArrayInputStream(wsdl.getBytes()));
                    generatedSchemas = this.cacheSchemas(servicePath, source);
                }
                if (!(path = servicePath.toString()).startsWith("/")) {
                    path = "/" + path;
                }
                JaxbInvoker invoker = new JaxbInvoker(invocationChains);
                EndpointConfiguration configuration = new EndpointConfiguration(seiClass, serviceName, portName, path, wsdlLocation, invoker, features, bindingId, generatedWsdl, generatedSchemas);
                this.endpointService.registerService(configuration);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (EndpointException e) {
            throw new WiringException((Throwable)((Object)e));
        }
        catch (CacheException e) {
            throw new WiringException((Throwable)e);
        }
    }

    private List<URL> cacheSchemas(URI servicePath, MetroJavaSourceDefinition source) throws CacheException {
        ArrayList<URL> schemas = new ArrayList<URL>();
        for (Map.Entry<String, String> entry : source.getSchemas().entrySet()) {
            URI uri = URI.create(servicePath + "/" + entry.getKey());
            ByteArrayInputStream bas = new ByteArrayInputStream(entry.getValue().getBytes());
            URL url = this.artifactCache.cache(uri, (InputStream)bas);
            schemas.add(url);
        }
        return schemas;
    }
}

