/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import com.sun.xml.wss.SecurityEnvironment;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.ws.WebServiceFeature;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroJavaTargetDefinition;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.MetroJavaTargetInterceptor;
import org.fabric3.binding.ws.metro.runtime.core.MetroProxyObjectFactory;
import org.fabric3.binding.ws.metro.runtime.policy.FeatureResolver;
import org.fabric3.binding.ws.metro.runtime.wire.WireAttacherHelper;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.artifact.ArtifactCache;
import org.fabric3.spi.artifact.CacheException;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.fabric3.spi.xml.XMLFactory;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetroJavaTargetWireAttacher
implements TargetWireAttacher<MetroJavaTargetDefinition> {
    private ClassLoaderRegistry registry;
    private FeatureResolver resolver;
    private WireAttacherHelper wireAttacherHelper;
    private ArtifactCache artifactCache;
    private SecurityEnvironment securityEnvironment;
    private ExecutorService executorService;
    private XMLInputFactory xmlInputFactory;

    public MetroJavaTargetWireAttacher(@Reference ClassLoaderRegistry registry, @Reference FeatureResolver resolver, @Reference WireAttacherHelper wireAttacherHelper, @Reference ArtifactCache artifactCache, @Reference SecurityEnvironment securityEnvironment, @Reference ExecutorService executorService, @Reference XMLFactory xmlFactory) {
        this.registry = registry;
        this.resolver = resolver;
        this.wireAttacherHelper = wireAttacherHelper;
        this.artifactCache = artifactCache;
        this.securityEnvironment = securityEnvironment;
        this.executorService = executorService;
        this.xmlInputFactory = xmlFactory.newInputFactoryInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(PhysicalSourceDefinition source, MetroJavaTargetDefinition target, Wire wire) throws WiringException {
        try {
            ReferenceEndpointDefinition endpointDefinition = target.getEndpointDefinition();
            URI classLoaderId = target.getSEIClassLoaderUri();
            List<QName> requestedIntents = target.getIntents();
            ClassLoader classLoader = this.registry.getClassLoader(classLoaderId);
            String interfaze = target.getInterface();
            byte[] bytes = target.getGeneratedInterface();
            if (!(classLoader instanceof SecureClassLoader)) {
                throw new WiringException("Classloader for " + interfaze + " must be a SecureClassLoader");
            }
            Class<?> seiClass = this.wireAttacherHelper.loadSEI(interfaze, bytes, (SecureClassLoader)classLoader);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                URL wsdlLocation = target.getWsdlLocation();
                URL generatedWsdl = null;
                URI servicePath = target.getEndpointDefinition().getUrl().toURI();
                String wsdl = target.getWsdl();
                if (wsdl != null) {
                    generatedWsdl = wsdlLocation = this.artifactCache.cache(servicePath, (InputStream)new ByteArrayInputStream(wsdl.getBytes()));
                    this.cacheSchemas(servicePath, target);
                }
                WebServiceFeature[] features = this.resolver.getFeatures(requestedIntents);
                MetroProxyObjectFactory proxyFactory = new MetroProxyObjectFactory(endpointDefinition, wsdlLocation, generatedWsdl, seiClass, features, this.executorService, this.securityEnvironment, this.xmlInputFactory);
                this.attacheInterceptors(seiClass, target, wire, proxyFactory);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (CacheException e) {
            throw new WiringException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new WiringException((Throwable)e);
        }
    }

    public ObjectFactory<?> createObjectFactory(MetroJavaTargetDefinition target) throws WiringException {
        return null;
    }

    public void detach(PhysicalSourceDefinition source, MetroJavaTargetDefinition target) throws WiringException {
    }

    private List<URL> cacheSchemas(URI servicePath, MetroJavaTargetDefinition target) throws CacheException {
        ArrayList<URL> schemas = new ArrayList<URL>();
        for (Map.Entry<String, String> entry : target.getSchemas().entrySet()) {
            URI uri = URI.create(servicePath + "/" + entry.getKey());
            ByteArrayInputStream bas = new ByteArrayInputStream(entry.getValue().getBytes());
            URL url = this.artifactCache.cache(uri, (InputStream)bas);
            schemas.add(url);
        }
        return schemas;
    }

    private void attacheInterceptors(Class<?> seiClass, MetroJavaTargetDefinition target, Wire wire, ObjectFactory<?> proxyFactory) {
        Method[] methods = seiClass.getMethods();
        SecurityConfiguration securityConfiguration = target.getSecurityConfiguration();
        ConnectionConfiguration connectionConfiguration = target.getConnectionConfiguration();
        for (InvocationChain chain : wire.getInvocationChains()) {
            Method method = null;
            for (Method meth : methods) {
                if (!chain.getPhysicalOperation().getName().equals(meth.getName())) continue;
                method = meth;
                break;
            }
            boolean oneWay = chain.getPhysicalOperation().isOneWay();
            MetroJavaTargetInterceptor targetInterceptor = new MetroJavaTargetInterceptor(proxyFactory, method, oneWay, securityConfiguration, connectionConfiguration);
            chain.addInterceptor((Interceptor)targetInterceptor);
        }
    }
}

