/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import com.sun.xml.ws.api.BindingID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import org.fabric3.binding.ws.metro.provision.MetroWsdlSourceDefinition;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.binding.ws.metro.runtime.core.DocumentInvoker;
import org.fabric3.binding.ws.metro.runtime.core.EndpointConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.EndpointException;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.F3Provider;
import org.fabric3.binding.ws.metro.runtime.policy.FeatureResolver;
import org.fabric3.binding.ws.metro.runtime.wire.AbstractMetroSourceWireAttacher;
import org.fabric3.binding.ws.metro.util.BindingIdResolver;
import org.fabric3.spi.artifact.ArtifactCache;
import org.fabric3.spi.artifact.CacheException;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetroWsdlSourceWireAttacher
extends AbstractMetroSourceWireAttacher<MetroWsdlSourceDefinition> {
    private FeatureResolver featureResolver;
    private BindingIdResolver bindingIdResolver;
    private ArtifactCache cache;

    public MetroWsdlSourceWireAttacher(@Reference FeatureResolver featureResolver, @Reference BindingIdResolver bindingIdResolver, @Reference EndpointService endpointService, @Reference ArtifactCache cache) {
        super(endpointService);
        this.featureResolver = featureResolver;
        this.bindingIdResolver = bindingIdResolver;
        this.cache = cache;
    }

    public void attach(MetroWsdlSourceDefinition source, PhysicalTargetDefinition target, Wire wire) throws WiringException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ServiceEndpointDefinition endpointDefinition = source.getEndpointDefinition();
            QName serviceName = endpointDefinition.getServiceName();
            QName portName = endpointDefinition.getPortName();
            URI servicePath = endpointDefinition.getServicePath();
            List invocationChains = wire.getInvocationChains();
            List<QName> requestedIntents = source.getIntents();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            BindingID bindingId = this.bindingIdResolver.resolveBindingId(requestedIntents);
            WebServiceFeature[] features = this.featureResolver.getFeatures(requestedIntents);
            String path = servicePath.toString();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            String wsdl = source.getWsdl();
            URL wsdlLocation = this.cache.cache(servicePath, (InputStream)new ByteArrayInputStream(wsdl.getBytes()));
            List<URL> generatedSchemas = null;
            DocumentInvoker invoker = new DocumentInvoker(invocationChains);
            EndpointConfiguration configuration = new EndpointConfiguration(F3Provider.class, serviceName, portName, path, wsdlLocation, invoker, features, bindingId, null, generatedSchemas);
            this.endpointService.registerService(configuration);
        }
        catch (CacheException e) {
            throw new WiringException((Throwable)e);
        }
        catch (EndpointException e) {
            throw new WiringException((Throwable)((Object)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public void detach(MetroWsdlSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        try {
            URI servicePath = source.getEndpointDefinition().getServicePath();
            this.cache.remove(servicePath);
        }
        catch (CacheException e) {
            throw new WiringException((Throwable)e);
        }
    }
}

