/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import com.sun.xml.wss.SecurityEnvironment;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroWsdlTargetDefinition;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.MetroDispatchObjectFactory;
import org.fabric3.binding.ws.metro.runtime.core.MetroDispatchTargetInterceptor;
import org.fabric3.binding.ws.metro.runtime.policy.FeatureResolver;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.artifact.ArtifactCache;
import org.fabric3.spi.artifact.CacheException;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetroWsdlTargetWireAttacher
implements TargetWireAttacher<MetroWsdlTargetDefinition> {
    private FeatureResolver resolver;
    private SecurityEnvironment securityEnvironment;
    private ExecutorService executorService;
    private ArtifactCache cache;

    public MetroWsdlTargetWireAttacher(@Reference FeatureResolver resolver, @Reference SecurityEnvironment securityEnvironment, @Reference ExecutorService executorService, @Reference ArtifactCache cache) {
        this.resolver = resolver;
        this.securityEnvironment = securityEnvironment;
        this.executorService = executorService;
        this.cache = cache;
    }

    public void attach(PhysicalSourceDefinition source, MetroWsdlTargetDefinition target, Wire wire) throws WiringException {
        URL wsdlLocation;
        ReferenceEndpointDefinition endpointDefinition = target.getEndpointDefinition();
        List<QName> requestedIntents = target.getIntents();
        WebServiceFeature[] features = this.resolver.getFeatures(requestedIntents);
        String wsdl = target.getWsdl();
        try {
            URI servicePath = target.getEndpointDefinition().getUrl().toURI();
            wsdlLocation = this.cache.cache(servicePath, (InputStream)new ByteArrayInputStream(wsdl.getBytes()));
        }
        catch (CacheException e) {
            throw new WiringException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new WiringException((Throwable)e);
        }
        MetroDispatchObjectFactory proxyFactory = new MetroDispatchObjectFactory(endpointDefinition, wsdlLocation, null, features, this.executorService, this.securityEnvironment);
        SecurityConfiguration securityConfiguration = target.getSecurityConfiguration();
        ConnectionConfiguration connectionConfiguration = target.getConnectionConfiguration();
        for (InvocationChain chain : wire.getInvocationChains()) {
            boolean oneWay = chain.getPhysicalOperation().isOneWay();
            MetroDispatchTargetInterceptor targetInterceptor = new MetroDispatchTargetInterceptor(proxyFactory, oneWay, securityConfiguration, connectionConfiguration);
            chain.addInterceptor((Interceptor)targetInterceptor);
        }
    }

    public ObjectFactory<?> createObjectFactory(MetroWsdlTargetDefinition target) throws WiringException {
        return null;
    }

    public void detach(PhysicalSourceDefinition source, MetroWsdlTargetDefinition target) throws WiringException {
        try {
            this.cache.remove(target.getUri());
        }
        catch (CacheException e) {
            throw new WiringException((Throwable)e);
        }
    }
}

