/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import java.lang.reflect.InvocationTargetException;
import java.security.SecureClassLoader;
import org.fabric3.binding.ws.metro.runtime.wire.WireAttacherHelper;
import org.fabric3.binding.ws.metro.util.ClassDefiner;
import org.fabric3.binding.ws.metro.util.ClassLoaderUpdater;
import org.fabric3.spi.builder.WiringException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireAttacherHelperImpl
implements WireAttacherHelper {
    private ClassDefiner classDefiner;
    private ClassLoaderUpdater classLoaderUpdater;

    public WireAttacherHelperImpl(@Reference ClassDefiner classDefiner, @Reference ClassLoaderUpdater classLoaderUpdater) {
        this.classDefiner = classDefiner;
        this.classLoaderUpdater = classLoaderUpdater;
    }

    @Override
    public Class<?> loadSEI(String interfaze, byte[] classBytes, SecureClassLoader classLoader) throws WiringException {
        try {
            Class<?> seiClass = classBytes != null ? this.classDefiner.defineClass(interfaze, classBytes, classLoader) : classLoader.loadClass(interfaze);
            this.classLoaderUpdater.updateClassLoader(seiClass);
            return seiClass;
        }
        catch (ClassNotFoundException e) {
            throw new WiringException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WiringException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new WiringException((Throwable)e);
        }
    }
}

