/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.util.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.util.graph.DirectedGraph;
import org.fabric3.util.graph.Edge;
import org.fabric3.util.graph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraphImpl<T>
implements DirectedGraph<T> {
    private Map<Vertex<T>, VertexHolder> graphVertices = new HashMap<Vertex<T>, VertexHolder>();
    private Set<Edge<T>> graphEdges = new HashSet<Edge<T>>();

    @Override
    public Set<Vertex<T>> getVertices() {
        return this.graphVertices.keySet();
    }

    @Override
    public void add(Vertex<T> vertex) {
        if (this.graphVertices.containsKey(vertex)) {
            return;
        }
        this.graphVertices.put(vertex, new VertexHolder());
    }

    @Override
    public void remove(Vertex<T> vertex) {
        ArrayList<Edge<T>> edges = new ArrayList<Edge<T>>(this.getOutgoingEdges(vertex));
        for (Edge edge : edges) {
            this.removeEdge(edge);
        }
        this.graphVertices.remove(vertex);
    }

    @Override
    public Set<Vertex<T>> getAdjacentVertices(Vertex<T> vertex) {
        HashSet<Vertex<T>> adjacentVertices = new HashSet<Vertex<T>>();
        Set<Edge<T>> incidentEdges = this.getOutgoingEdges(vertex);
        if (incidentEdges != null) {
            for (Edge<T> edge : incidentEdges) {
                adjacentVertices.add(edge.getOppositeVertex(vertex));
            }
        }
        return adjacentVertices;
    }

    @Override
    public List<Vertex<T>> getOutgoingAdjacentVertices(Vertex<T> vertex) {
        return this.getAdjacentVertices(vertex, true);
    }

    @Override
    public List<Vertex<T>> getIncomingAdjacentVertices(Vertex<T> vertex) {
        return this.getAdjacentVertices(vertex, false);
    }

    @Override
    public Edge<T> getEdge(Vertex<T> source, Vertex<T> sink) {
        Set<Edge<T>> edges = this.getOutgoingEdges(source);
        for (Edge<T> edge : edges) {
            if (edge.getSink() != sink) continue;
            return edge;
        }
        return null;
    }

    @Override
    public Set<Edge<T>> getOutgoingEdges(Vertex<T> vertex) {
        return this.graphVertices.get(vertex).getOutgoingEdges();
    }

    @Override
    public Set<Edge<T>> getIncomingEdges(Vertex<T> vertex) {
        return this.graphVertices.get(vertex).getIncomingEdges();
    }

    @Override
    public Set<Edge<T>> getEdges() {
        return this.graphEdges;
    }

    @Override
    public void add(Edge<T> edge) {
        if (this.graphEdges.contains(edge)) {
            return;
        }
        Vertex<T> source = edge.getSource();
        Vertex<T> sink = edge.getSink();
        if (!this.graphVertices.containsKey(source)) {
            this.add(source);
        }
        if (sink != source && !this.graphVertices.containsKey(sink)) {
            this.add(sink);
        }
        Set<Edge<T>> sourceEdges = this.getOutgoingEdges(source);
        sourceEdges.add(edge);
        if (source != sink) {
            Set<Edge<T>> sinkEdges = this.getIncomingEdges(sink);
            sinkEdges.add(edge);
        }
        this.graphEdges.add(edge);
        VertexHolder sourceHolder = this.graphVertices.get(edge.getSource());
        VertexHolder sinkHolder = this.graphVertices.get(edge.getSink());
        sourceHolder.getOutgoingEdges().add(edge);
        sinkHolder.getIncomingEdges().add(edge);
    }

    @Override
    public void remove(Edge<T> edge) {
        this.removeEdge(edge);
        Vertex<T> source = edge.getSource();
        Vertex<T> sink = edge.getSink();
        VertexHolder sourceHolder = this.graphVertices.get(source);
        VertexHolder sinkHolder = this.graphVertices.get(sink);
        sourceHolder.getOutgoingEdges().remove(edge);
        sinkHolder.getIncomingEdges().remove(edge);
    }

    private void removeEdge(Edge<T> edge) {
        Vertex<T> source = edge.getSource();
        Set<Edge<T>> sourceEdges = this.getOutgoingEdges(source);
        sourceEdges.remove(edge);
        Vertex<T> sink = edge.getSink();
        Set<Edge<T>> sinkEdges = this.getIncomingEdges(sink);
        sinkEdges.remove(edge);
        this.graphEdges.remove(edge);
    }

    private List<Vertex<T>> getAdjacentVertices(Vertex<T> vertex, boolean outGoing) {
        ArrayList<Vertex<T>> adjacentVertices = new ArrayList<Vertex<T>>();
        Set<Edge<T>> edges = outGoing ? this.getOutgoingEdges(vertex) : this.getIncomingEdges(vertex);
        for (Edge<T> edge : edges) {
            Vertex<T> oppositeVertex = edge.getOppositeVertex(vertex);
            adjacentVertices.add(oppositeVertex);
        }
        return adjacentVertices;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VertexHolder {
        private Set<Edge<T>> incoming = new HashSet();
        private Set<Edge<T>> outgoingEdges = new HashSet();

        private VertexHolder() {
        }

        public Set<Edge<T>> getIncomingEdges() {
            return this.incoming;
        }

        public Set<Edge<T>> getOutgoingEdges() {
            return this.outgoingEdges;
        }
    }
}

