/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.admin.controller;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.admin.controller.DomainMBeanMonitor;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.host.contribution.Deployable;
import org.fabric3.host.domain.AssemblyException;
import org.fabric3.host.domain.AssemblyFailure;
import org.fabric3.host.domain.CompositeAlreadyDeployedException;
import org.fabric3.host.domain.ContributionNotInstalledException;
import org.fabric3.host.domain.DeployableNotFoundException;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.host.domain.DomainException;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.management.domain.ComponentInfo;
import org.fabric3.management.domain.ContributionNotFoundException;
import org.fabric3.management.domain.ContributionNotInstalledManagementException;
import org.fabric3.management.domain.DeploymentManagementException;
import org.fabric3.management.domain.InvalidDeploymentException;
import org.fabric3.management.domain.InvalidPathException;
import org.fabric3.management.domain.NoDeployablesManagementException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Management
public abstract class AbstractDomainMBean {
    protected Domain domain;
    protected MetaDataStore store;
    protected LogicalComponentManager lcm;
    protected HostInfo info;
    protected DomainMBeanMonitor monitor;
    protected String domainUri;

    public AbstractDomainMBean(Domain domain, MetaDataStore store, LogicalComponentManager lcm, HostInfo info, DomainMBeanMonitor monitor) {
        this.domain = domain;
        this.store = store;
        this.lcm = lcm;
        this.info = info;
        this.domainUri = info.getDomain().toString();
        this.monitor = monitor;
    }

    @ManagementOperation(description="Deploys a contribution to the domain.  All contained deployables will be included in the domain composite.")
    public void deploy(URI uri) throws DeploymentManagementException {
        this.deploy(uri, null);
    }

    @ManagementOperation(description="Deploys a contribution to the domain using the specified deployment plan.  All contained deployables will be included in the domain composite.")
    public void deploy(URI uri, String plan) throws DeploymentManagementException {
        Contribution contribution = this.store.find(uri);
        if (contribution == null) {
            throw new ContributionNotFoundException("Contribution not found: " + uri);
        }
        try {
            this.domain.activateDefinitions(uri);
        }
        catch (DeploymentException e) {
            throw new ContributionNotInstalledManagementException(e.getMessage());
        }
        for (Deployable deployable : contribution.getManifest().getDeployables()) {
            QName name = deployable.getName();
            try {
                if (plan == null) {
                    this.domain.include(name);
                    continue;
                }
                this.domain.include(name, plan);
            }
            catch (ContributionNotInstalledException e) {
                throw new ContributionNotInstalledManagementException(e.getMessage());
            }
            catch (AssemblyException e) {
                ArrayList<String> errors = new ArrayList<String>();
                for (AssemblyFailure error : e.getErrors()) {
                    errors.add(error.getMessage() + " (" + error.getContributionUri() + ")");
                }
                throw new InvalidDeploymentException("Error deploying " + uri, errors);
            }
            catch (CompositeAlreadyDeployedException e) {
                throw new ContributionNotInstalledManagementException(e.getMessage());
            }
            catch (DeployableNotFoundException e) {
                throw new ContributionNotInstalledManagementException(e.getMessage());
            }
            catch (DeploymentException e) {
                this.reportError(uri, (DomainException)e);
            }
        }
    }

    @ManagementOperation(description="Undeploys deployables contained in a contribution")
    public void undeploy(URI uri, boolean force) throws DeploymentManagementException {
        Contribution contribution = this.store.find(uri);
        if (contribution == null) {
            throw new ContributionNotFoundException("Contribution not found: " + uri);
        }
        List deployables = contribution.getManifest().getDeployables();
        if (deployables.isEmpty()) {
            throw new NoDeployablesManagementException("The contribution does not contain any deployable composites: " + uri);
        }
        for (Deployable deployable : deployables) {
            try {
                QName name = deployable.getName();
                this.domain.undeploy(name, force);
            }
            catch (DeploymentException e) {
                this.reportError(uri, (DomainException)e);
            }
        }
        try {
            this.domain.deactivateDefinitions(uri);
        }
        catch (DeploymentException e) {
            throw new ContributionNotInstalledManagementException(e.getMessage());
        }
    }

    @ManagementOperation(description="Returns a list of ComponentInfo instances representing the components deployed to the given composite path. The path / is interpreted as the domain composite.")
    public List<ComponentInfo> getDeployedComponents(String path) throws InvalidPathException {
        String[] tokens = path.split("/");
        LogicalCompositeComponent currentComponent = this.lcm.getRootComponent();
        ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>();
        String currentPath = this.domainUri;
        if (tokens.length > 0 && !this.domainUri.endsWith(tokens[0]) && !tokens[0].equals("/")) {
            throw new InvalidPathException("Path not found: " + path);
        }
        for (int i = 1; i < tokens.length; ++i) {
            LogicalComponent component = currentComponent.getComponent(URI.create(currentPath = currentPath + "/" + tokens[i]));
            if (component == null) {
                throw new InvalidPathException("Deployed composite not exist: " + path);
            }
            if (!(component instanceof LogicalCompositeComponent)) {
                throw new InvalidPathException("Component is not a composite: " + path);
            }
            currentComponent = (LogicalCompositeComponent)component;
        }
        for (LogicalComponent component : currentComponent.getComponents()) {
            URI uri = component.getUri();
            URI contributionUri = component.getDefinition().getContributionUri();
            QName deployable = component.getDeployable();
            String zone = component.getZone();
            ComponentInfo info = new ComponentInfo(uri, contributionUri, deployable, zone);
            infos.add(info);
        }
        return infos;
    }

    protected void reportError(URI uri, DomainException e) throws DeploymentManagementException {
        this.monitor.error("Error deploying " + uri, (Exception)e);
        Object cause = e;
        while (((Throwable)cause).getCause() != null) {
            cause = ((Throwable)cause).getCause();
        }
        throw new DeploymentManagementException(((Throwable)cause).getMessage());
    }
}

