/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.admin.controller;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Servlet;
import javax.xml.namespace.QName;
import org.fabric3.admin.controller.ContributionServiceMBeanMonitor;
import org.fabric3.admin.controller.ContributionServlet;
import org.fabric3.admin.controller.ProfileServlet;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.contribution.ArtifactValidationFailure;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.contribution.ContributionInUseException;
import org.fabric3.host.contribution.ContributionLockedException;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.Deployable;
import org.fabric3.host.contribution.ValidationException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.management.contribution.ArtifactErrorInfo;
import org.fabric3.management.contribution.ContributionInUseManagementException;
import org.fabric3.management.contribution.ContributionInfo;
import org.fabric3.management.contribution.ContributionInstallException;
import org.fabric3.management.contribution.ContributionLockedManagementException;
import org.fabric3.management.contribution.ContributionRemoveException;
import org.fabric3.management.contribution.ContributionUninstallException;
import org.fabric3.management.contribution.ErrorInfo;
import org.fabric3.management.contribution.InvalidContributionException;
import org.fabric3.spi.VoidService;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.host.ServletHost;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
@Management(name="ContributionService", group="deployment", description="Manages contributions in a domain")
public class ContributionServiceMBean
implements VoidService {
    private static final String REPOSITORY = "/admin/repository";
    private static final String PROFILE = "/admin/profile";
    private ServletHost servletHost;
    private ContributionService contributionService;
    private MetaDataStore metaDataStore;
    private ContributionServiceMBeanMonitor monitor;
    private String hostName;
    private String contributionAddress;
    private String profileAddress;

    public ContributionServiceMBean(@Reference ServletHost servletHost, @Reference ContributionService contributionService, @Reference MetaDataStore metaDataStore, @Monitor ContributionServiceMBeanMonitor monitor) {
        this.servletHost = servletHost;
        this.contributionService = contributionService;
        this.metaDataStore = metaDataStore;
        this.monitor = monitor;
    }

    @Property
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Init
    public void init() throws Exception {
        this.initAddress();
        ContributionServlet contributionServlet = new ContributionServlet(this.contributionService, this.monitor);
        ProfileServlet profileServlet = new ProfileServlet(this.contributionService, this.monitor);
        this.servletHost.registerMapping("/admin/repository/*", (Servlet)contributionServlet);
        this.servletHost.registerMapping("/admin/profile/*", (Servlet)profileServlet);
    }

    @ManagementOperation(description="Returns the network address the service receives contribution archives on")
    public String getContributionServiceAddress() {
        return this.contributionAddress;
    }

    @ManagementOperation(description="Returns the network address the service receives profile archives on")
    public String getProfileServiceAddress() {
        return this.profileAddress;
    }

    @ManagementOperation(description="Returns metadata for all contributions deployed in a domain")
    public Set<ContributionInfo> getContributions() {
        Set contributions = this.metaDataStore.getContributions();
        TreeSet<ContributionInfo> infos = new TreeSet<ContributionInfo>();
        for (Contribution contribution : contributions) {
            URI uri = contribution.getUri();
            String state = contribution.getState().toString();
            long timestamp = contribution.getTimestamp();
            ArrayList<QName> deployables = new ArrayList<QName>();
            for (Deployable deployable : contribution.getManifest().getDeployables()) {
                deployables.add(deployable.getName());
            }
            ContributionInfo info = new ContributionInfo(uri, state, deployables, timestamp);
            infos.add(info);
        }
        return infos;
    }

    @ManagementOperation(description="Installs a stored contribution")
    public void install(URI uri) throws ContributionInstallException {
        try {
            this.contributionService.install(uri);
        }
        catch (ValidationException e) {
            ArrayList<Object> errors = new ArrayList<Object>();
            for (ValidationFailure failure : e.getErrors()) {
                if (failure instanceof ArtifactValidationFailure) {
                    ArtifactValidationFailure avf = (ArtifactValidationFailure)failure;
                    ArtifactErrorInfo error = new ArtifactErrorInfo(avf.getArtifactName());
                    for (ValidationFailure entry : avf.getFailures()) {
                        ErrorInfo info = new ErrorInfo(entry.getMessage());
                        error.addError(info);
                    }
                    errors.add(error);
                    continue;
                }
                ErrorInfo info = new ErrorInfo(failure.getMessage());
                errors.add(info);
            }
            throw new InvalidContributionException("Error installing " + uri, errors);
        }
        catch (ContributionException e) {
            this.monitor.error("Error installing: " + uri, (Exception)((Object)e));
            throw new ContributionInstallException(this.getErrorMessage(e));
        }
    }

    @ManagementOperation(description="Uninstalls a contribution")
    public void uninstall(URI uri) throws ContributionUninstallException {
        try {
            this.contributionService.uninstall(uri);
        }
        catch (ContributionInUseException e) {
            throw new ContributionInUseManagementException(e.getMessage(), e.getUri(), e.getContributions());
        }
        catch (ContributionLockedException e) {
            throw new ContributionLockedManagementException(e.getMessage(), e.getUri(), e.getDeployables());
        }
        catch (ContributionException e) {
            this.monitor.error("Error uninstalling contribution: " + uri, (Exception)((Object)e));
            throw new ContributionUninstallException(this.getErrorMessage(e));
        }
    }

    @ManagementOperation(description="Removes a contribution")
    public void remove(URI uri) throws ContributionRemoveException {
        try {
            this.contributionService.remove(uri);
        }
        catch (ContributionException e) {
            this.monitor.error("Error removing contribution: " + uri, (Exception)((Object)e));
            throw new ContributionRemoveException(this.getErrorMessage(e));
        }
    }

    @ManagementOperation(description="Installs a profile")
    public void installProfile(URI uri) throws ContributionInstallException {
        try {
            this.contributionService.installProfile(uri);
        }
        catch (ValidationException e) {
            ArrayList<Object> errors = new ArrayList<Object>();
            for (ValidationFailure failure : e.getErrors()) {
                if (failure instanceof ArtifactValidationFailure) {
                    ArtifactValidationFailure avf = (ArtifactValidationFailure)failure;
                    ArtifactErrorInfo error = new ArtifactErrorInfo(avf.getArtifactName());
                    for (ValidationFailure entry : avf.getFailures()) {
                        ErrorInfo info = new ErrorInfo(entry.getMessage());
                        error.addError(info);
                    }
                    errors.add(error);
                    continue;
                }
                ErrorInfo info = new ErrorInfo(failure.getMessage());
                errors.add(info);
            }
            throw new InvalidContributionException("Error installing " + uri, errors);
        }
        catch (ContributionException e) {
            this.monitor.error("Error installing: " + uri, (Exception)((Object)e));
            throw new ContributionInstallException(this.getErrorMessage(e));
        }
    }

    @ManagementOperation(description="Uninstalls a profile")
    public void uninstallProfile(URI uri) throws ContributionUninstallException {
        try {
            this.contributionService.uninstallProfile(uri);
        }
        catch (ContributionInUseException e) {
            throw new ContributionInUseManagementException(e.getMessage(), e.getUri(), e.getContributions());
        }
        catch (ContributionLockedException e) {
            throw new ContributionLockedManagementException(e.getMessage(), e.getUri(), e.getDeployables());
        }
        catch (ContributionException e) {
            this.monitor.error("Error uninstalling profile: " + uri, (Exception)((Object)e));
            throw new ContributionUninstallException(this.getErrorMessage(e));
        }
    }

    @ManagementOperation(description="Removes a profile from the domain")
    public void removeProfile(URI uri) throws ContributionRemoveException {
        try {
            this.contributionService.removeProfile(uri);
        }
        catch (ContributionException e) {
            this.monitor.error("Error removing profile: " + uri, (Exception)((Object)e));
            throw new ContributionRemoveException(this.getErrorMessage(e));
        }
    }

    private void initAddress() throws UnknownHostException {
        String baseAddress = this.hostName == null ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(this.hostName).getHostAddress();
        this.contributionAddress = "http://" + baseAddress + ":" + this.servletHost.getHttpPort() + REPOSITORY;
        this.profileAddress = "http://" + baseAddress + ":" + this.servletHost.getHttpPort() + PROFILE;
    }

    private String getErrorMessage(ContributionException e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause.getMessage();
    }
}

