/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.admin.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fabric3.admin.controller.ContributionServiceMBeanMonitor;
import org.fabric3.admin.controller.InputStreamContributionSource;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.contribution.DuplicateContributionException;

public class ContributionServlet
extends HttpServlet {
    private static final long serialVersionUID = -8286023912719635905L;
    private ContributionService contributionService;
    private ContributionServiceMBeanMonitor monitor;

    public ContributionServlet(ContributionService contributionService, ContributionServiceMBeanMonitor monitor) {
        this.contributionService = contributionService;
        this.monitor = monitor;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null) {
            resp.setStatus(400);
            resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>No path info</description>");
            return;
        }
        int pos = path.lastIndexOf("/");
        if (pos < 0) {
            resp.setStatus(400);
            resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>Invalid path: " + path + " </description>");
            return;
        }
        String substr = path.substring(pos + 1);
        try {
            URI uri = new URI(substr);
            InputStreamContributionSource source = new InputStreamContributionSource(uri, (InputStream)req.getInputStream());
            this.contributionService.store((ContributionSource)source);
            resp.setStatus(200);
        }
        catch (URISyntaxException e) {
            this.monitor.error("Invalid contribution URI:", e);
            resp.setStatus(400);
            resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>Invalid URI: " + substr + "</description>");
        }
        catch (DuplicateContributionException e) {
            resp.setStatus(420);
        }
        catch (ContributionException e) {
            this.monitor.error("Error storing contribution:", (Exception)((Object)e));
            resp.setStatus(422);
            PrintWriter writer = resp.getWriter();
            writer.write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>Error storing contribution: " + e.getMessage() + "</description>");
        }
    }
}

