/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.admin.controller;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fabric3.admin.controller.ContributionServiceMBeanMonitor;
import org.fabric3.admin.controller.WrappedStreamContributionSource;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.contribution.DuplicateProfileException;
import org.fabric3.host.contribution.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServlet
extends HttpServlet {
    private static final long serialVersionUID = -8286023912719635905L;
    private static final String EXTENSIONS = "extensions";
    private ContributionService contributionService;
    private ContributionServiceMBeanMonitor monitor;

    public ProfileServlet(ContributionService contributionService, ContributionServiceMBeanMonitor monitor) {
        this.contributionService = contributionService;
        this.monitor = monitor;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null) {
            resp.setStatus(400);
            resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>No path info</description>");
            return;
        }
        int pos = path.lastIndexOf("/");
        if (pos < 0) {
            resp.setStatus(400);
            resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>Invalid path: " + path + " </description>");
            return;
        }
        String substr = path.substring(pos + 1);
        try {
            if (!substr.endsWith(".jar") && !substr.endsWith(".zip")) {
                resp.setStatus(422);
                resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>Profile must be a zip or jar</description>");
                return;
            }
            URI uri = new URI(substr);
            if (this.contributionService.profileExists(uri)) {
                resp.setStatus(420);
                return;
            }
            this.store(uri, (InputStream)req.getInputStream());
            resp.setStatus(201);
        }
        catch (URISyntaxException e) {
            this.monitor.error("Invalid contribution URI:", e);
            resp.setStatus(400);
            resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>Invalid URI: " + substr + "</description>");
        }
        catch (DuplicateProfileException e) {
            resp.setStatus(420);
        }
        catch (IOException e) {
            this.monitor.error("Error storing contribution:", e);
            resp.setStatus(422);
            resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>Error storing profile</description>");
        }
        catch (StoreException e) {
            this.monitor.error("Error storing contribution:", (Exception)((Object)e));
            resp.setStatus(422);
            resp.getWriter().write("<?xml version=\"1.0\" encoding=\"ASCII\"?><description>Error storing profile</description>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<URI> store(URI profileUri, InputStream stream) throws IOException, URISyntaxException, StoreException {
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            ArrayList<URI> contributionUris = new ArrayList<URI>();
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String[] tokens;
                if (entry.isDirectory() || (tokens = entry.getName().split("/")).length != 2 || !EXTENSIONS.equals(tokens[0])) continue;
                URI contributionUri = new URI(tokens[1]);
                if (!this.contributionService.exists(contributionUri)) {
                    WrappedStreamContributionSource contributionSource = new WrappedStreamContributionSource(contributionUri, jarStream, true);
                    this.contributionService.store((ContributionSource)contributionSource);
                }
                contributionUris.add(contributionUri);
            }
            this.contributionService.registerProfile(profileUri, contributionUris);
            ArrayList<URI> arrayList = contributionUris;
            return arrayList;
        }
        finally {
            try {
                if (jarStream != null) {
                    jarStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

