/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.admin.controller;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.admin.controller.AbstractDomainMBean;
import org.fabric3.admin.controller.DomainMBeanMonitor;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.Deployable;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.host.domain.DomainException;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.management.domain.ContributionNotFoundException;
import org.fabric3.management.domain.DeploymentManagementException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.osoa.sca.annotations.Reference;

@Management(name="RuntimeDomain", group="kernel", description="Manages the runtime domain")
public class RuntimeDomainMBeanImpl
extends AbstractDomainMBean {
    private ContributionService contributionService;

    public RuntimeDomainMBeanImpl(@Reference(name="domain") Domain domain, @Reference ContributionService contributionService, @Reference MetaDataStore store, @Reference LogicalComponentManager lcm, @Reference HostInfo info, @Monitor DomainMBeanMonitor monitor) {
        super(domain, store, lcm, info, monitor);
        this.contributionService = contributionService;
    }

    @ManagementOperation(description="Deploys a profile to the runtime")
    public void deployProfile(URI profileUri) throws DeploymentManagementException {
        List uris = this.contributionService.getContributionsInProfile(profileUri);
        try {
            Iterator it = uris.iterator();
            while (it.hasNext()) {
                URI uri = (URI)it.next();
                Contribution contribution = this.store.find(uri);
                if (!contribution.isLocked()) continue;
                it.remove();
            }
            this.domain.include(uris);
        }
        catch (DeploymentException e) {
            throw new DeploymentManagementException("Error deploying profile " + profileUri + ":" + e.getMessage());
        }
    }

    @ManagementOperation(description="Undeploys a profile")
    public void undeployProfile(URI uri) throws DeploymentManagementException {
        List uris = this.contributionService.getSortedContributionsInProfile(uri);
        for (URI contributionUri : uris) {
            Contribution contribution = this.store.find(contributionUri);
            if (contribution == null) {
                throw new ContributionNotFoundException("Contribution not found: " + contributionUri);
            }
            for (Deployable deployable : contribution.getManifest().getDeployables()) {
                try {
                    QName name = deployable.getName();
                    this.domain.undeploy(name);
                }
                catch (DeploymentException e) {
                    this.reportError(contributionUri, (DomainException)e);
                }
            }
        }
    }
}

