/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AnnotationProcessor;
import org.fabric3.spi.introspection.java.annotation.ClassVisitor;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassVisitor<I extends Implementation<? extends InjectingComponentType>>
implements ClassVisitor<I> {
    private Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation, I>> processors;
    private PolicyAnnotationProcessor policyProcessor;

    public DefaultClassVisitor(Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation, I>> processors) {
        this.processors = processors;
    }

    @org.osoa.sca.annotations.Constructor
    public DefaultClassVisitor() {
    }

    @Reference
    public void setProcessors(Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation, I>> processors) {
        this.processors = processors;
    }

    @Reference
    public void setPolicyProcessor(PolicyAnnotationProcessor processor) {
        this.policyProcessor = processor;
    }

    public void visit(I implementation, Class<?> clazz, IntrospectionContext context) {
        this.walk(implementation, clazz, clazz, false, context);
    }

    private void walk(I implementation, Class<?> clazz, Class<?> implClass, boolean isSuperClass, IntrospectionContext context) {
        if (!clazz.isInterface()) {
            this.walkSuperClasses(implementation, clazz, implClass, context);
        }
        this.walkInterfaces(implementation, clazz, implClass, context);
        this.walkClass(implementation, clazz, context);
        this.walkFields(implementation, clazz, implClass, context);
        this.walkMethods(implementation, clazz, implClass, context);
        if (!isSuperClass) {
            this.walkConstructors(implementation, clazz, implClass, context);
        }
    }

    private void walkSuperClasses(I implementation, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.walk(implementation, superClass, implClass, true, context);
        }
    }

    private void walkInterfaces(I implementation, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        for (Class<?> interfaze : clazz.getInterfaces()) {
            this.walk(implementation, interfaze, implClass, false, context);
        }
    }

    private void walkClass(I implementation, Class<?> clazz, IntrospectionContext context) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            this.visitType(annotation, clazz, implementation, context);
        }
    }

    private void walkFields(I implementation, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                this.visitField(annotation, field, implClass, implementation, context);
            }
        }
    }

    private void walkMethods(I implementation, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                this.visitMethod(annotation, method, implClass, implementation, context);
            }
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = parameterAnnotations[i]) {
                    this.visitMethodParameter(annotation, method, i, implClass, implementation, context);
                }
            }
        }
    }

    private void walkConstructors(I implementation, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                this.visitConstructor(annotation, constructor, implClass, implementation, context);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = parameterAnnotations[i]) {
                    this.visitConstructorParameter(annotation, constructor, i, implClass, implementation, context);
                }
            }
        }
    }

    private <A extends Annotation> void visitType(A annotation, Class<?> clazz, I implementation, IntrospectionContext context) {
        AnnotationProcessor<A, I> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitType(annotation, clazz, implementation, context);
        } else if (this.policyProcessor != null) {
            this.policyProcessor.process(annotation, implementation, context);
        }
    }

    private <A extends Annotation> void visitField(A annotation, Field field, Class<?> implClass, I implementation, IntrospectionContext context) {
        AnnotationProcessor<A, I> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitField(annotation, field, implClass, implementation, context);
        }
    }

    private <A extends Annotation> void visitMethod(A annotation, Method method, Class<?> implClass, I implementation, IntrospectionContext context) {
        AnnotationProcessor<A, I> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitMethod(annotation, method, implClass, implementation, context);
        }
    }

    private <A extends Annotation> void visitMethodParameter(A annotation, Method method, int index, Class<?> implClass, I implementation, IntrospectionContext context) {
        AnnotationProcessor<A, I> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitMethodParameter(annotation, method, index, implClass, implementation, context);
        }
    }

    private <A extends Annotation> void visitConstructor(A annotation, Constructor<?> constructor, Class<?> implClass, I implementation, IntrospectionContext context) {
        AnnotationProcessor<A, I> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitConstructor(annotation, constructor, implClass, implementation, context);
        }
    }

    private <A extends Annotation> void visitConstructorParameter(A annotation, Constructor<?> constructor, int index, Class<?> implClass, I implementation, IntrospectionContext context) {
        AnnotationProcessor<A, I> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitConstructorParameter(annotation, constructor, index, implClass, implementation, context);
        }
    }

    private <A extends Annotation> AnnotationProcessor<A, I> getProcessor(A annotation) {
        return this.processors.get(annotation.annotationType());
    }
}

